/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.environment;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Case;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.atomicstate.AtomicState;
import com.urbancode.commons.util.atomicstate.StateUpdate;
import com.urbancode.commons.util.environment.CaseInsensitiveEnvironment;
import com.urbancode.commons.util.environment.CaseSensitiveEnvironment;
import com.urbancode.commons.util.environment.EnvironmentUpdate;
import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.nonull.NonNullCollections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public abstract class Environment {
    private static final Environment globalInstance = Environment.createFromSystem();
    private final AtomicState<IImmutableMap<String, String>> environment;

    public static Environment getGlobalInstance() {
        return globalInstance;
    }

    public static Environment create(Case sensitivity, Map<String, String> value) {
        Environment result = sensitivity == Case.SENSITIVE ? new CaseSensitiveEnvironment(value) : new CaseInsensitiveEnvironment(value);
        return result;
    }

    public static Environment createFromSystem() {
        return Environment.create(Case.getSystemCaseSensitivity(), System.getenv());
    }

    public static Environment createFromGlobalInstance() {
        return Environment.getGlobalInstance().copy();
    }

    Environment(Map<String, String> initialValue) {
        Check.nonNull(initialValue, "initialValue");
        HashMap<String, String> copy = new HashMap<String, String>(initialValue);
        Check.allNonNull(copy, "initialValue");
        IImmutableMap<String, String> state = NonNullCollections.nonNullImmutableMap(this.newImmutableMap(copy));
        this.environment = new AtomicState<IImmutableMap<String, String>>(state);
    }

    public String get(String name) {
        Check.nonNull(name, "name");
        return (String)this.environment.get().get(name);
    }

    public void update(final EnvironmentUpdate update) {
        Check.nonNull(update, "update");
        this.environment.update(new StateUpdate<IImmutableMap<String, String>>(){

            @Override
            public IImmutableMap<String, String> newVersion(IImmutableMap<String, String> oldState) {
                Map<String, String> view = NonNullCollections.nonNullMap(Environment.this.newMap(oldState));
                update.update(view);
                return NonNullCollections.nonNullImmutableMap(Environment.this.newImmutableMap(view));
            }
        });
    }

    public void copyTo(Map<String, String> map) {
        Check.nonNull(map, "map");
        map.clear();
        map.putAll(this.get());
    }

    public Map<String, String> toMap() {
        return NonNullCollections.nonNullMap(this.newMap(this.get()));
    }

    public Map<String, String> toImmutableMap() {
        return this.get();
    }

    public abstract Environment copy();

    public abstract Case getCaseSensitivity();

    protected IImmutableMap<String, String> get() {
        return this.environment.get();
    }

    protected abstract IImmutableMap<String, String> newImmutableMap(Map<String, String> var1);

    protected abstract Map<String, String> newMap(Map<String, String> var1);
}

