/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

containmentPath = props['object'];
propName = props['propName'];
propValue = props['propValue'];
propType = props['propType'];

StringBuilder builder = new StringBuilder();
builder.append("updateJ2EEResourceProperty(")
           .append("\"").append(containmentPath).append("\"").append(",")
           .append("\"").append(propName).append("\"").append(",")
           .append("\"").append(propValue).append("\"").append(",")
           .append("\"").append(propType).append("\"")
builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
