/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def appName = props['appName'];
def appEdition = props['appEdition']
def sharedLibNames = props['sharedLibName'].split("\n");
def moduleURI = props['moduleURI'];

def batch = props['batch'];
props['batch'] = true;
for (int i = 0; i < sharedLibNames.length; i++) {
    String sharedLibName = sharedLibNames[i].trim();
    StringBuilder builder = new StringBuilder();
    builder.append("addSharedLibraryToModule(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(moduleURI).append("\"").append(",")
               .append("\'").append(sharedLibName).append("\'")
           .append(")")
    command = builder.toString();
    
    if (i == sharedLibNames.length -1) {
        props['batch'] = batch;
    }
    WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
    helper.execute(command);
}

