/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def cell = props['cell']
def server = props['server']
def node = props['node']
def cluster = props['cluster']
def appName = props['appName']
def appEdition = props['appEdition']

StringBuilder builder = new StringBuilder();
if (cluster != null && cluster.trim() != "" && !cluster.startsWith('${p:')) {
    builder.append("stopApplicationOnCluster(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\'").append(cluster).append("\'")
           .append(")")
    command = builder.toString();
}
else if (server != null && server.trim() != "" && !server.startsWith('${p:')) {
    builder.append("stopApplicationOnServer(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\'").append(server).append("\'").append(",")
               .append("\'").append(node).append("\'")
           .append(")")
    command = builder.toString();
}
else { /* Cell scope application stop*/
    builder.append("controlApplicationOnCell(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\'").append("stop").append("\'")
           .append(")")
    command = builder.toString();
}

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
