/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def blaName = props['blaName'].trim()
def compUnitName = props['compUnitName'].trim()
def node = props['node']?.trim()
def server = props['server']?.trim()
def cluster = props['cluster']?.trim()

String newTarget = "WebSphere:";
if (server == null || server.startsWith('${p:') || server.trim() == "") {
    newTarget += "cluster=" + cluster;
}
else {
    newTarget += "node=" + node + ",server=" + server;
}

StringBuilder builder = new StringBuilder();
builder.append("addTargetToCompUnit(")
           .append("\"").append(blaName).append("\"").append(",")
           .append("\"").append(compUnitName).append("\"").append(",")
           .append("\"").append(newTarget).append("\"")
builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
