/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

clusterName = props['clusterName'];
if (clusterName?.trim()) {
    scope="Cluster=" + clusterName;
}
else {
    scope=props['scope'];
}

dbType=props['dbType'];
provType=props['provType'];
implType= props['implType'];
name=props['name'];
desc=props['desc'];
classPath=props['classPath'];
nativePath=props['nativePath'];

StringBuilder builder = new StringBuilder();
builder.append("createJDBCProvider(")
           .append("\"").append(scope).append("\"").append(",")
           .append("\"").append(dbType).append("\"").append(",")
           .append("\"").append(provType).append("\"").append(",")
           .append("\"").append(implType).append("\"").append(",")
           .append("\"").append(name).append("\"").append(",")
           .append("\"").append(desc).append("\"").append(",")
           .append("\"").append(classPath).append("\"").append(",")
           .append("\"").append(nativePath).append("\"")
builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
