/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def appName = props['appName']
def appEdition = props['appEdition']
def ignoreRoutingRules = Boolean.valueOf(props['igonreRoutingRules']);

StringBuilder builder = new StringBuilder();
builder.append("deactivateEdition(")
           .append("\"").append(appName).append("\"").append(",")
           .append("\"").append(appEdition?:"").append("\"");
       if (ignoreRoutingRules) {
           builder.append(",").append("\"").append("true").append("\"")
       }
       builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
