/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper

def apTool                = new AirPluginTool(this.args[0], this.args[1])
def props                 = apTool.getStepProperties()
def propertiesFileName    = props['propertiesFileName']?.trim()
def configDataKey         = props['configDataKey']?.trim()
def configDataValue       = props['configDataValue']?.trim()
def optionsKey            = props['optionsKey']?.trim()
def optionsValue          = props['optionsValue']?.trim()
def filterMechanism       = props['filterMechanism']?.trim()
def selectedSubTypesKey   = props['selectedSubTypesKey']?.trim()
def selectedSubTypesValue = props['selectedSubTypesValue']?.trim()
def zipFileName           = props['zipFileName']?.trim()


def PLUGIN_HOME = System.getenv("PLUGIN_HOME")
def pluginHome  = new File(PLUGIN_HOME)
def scriptsDir  = new File(pluginHome, "jythonScripts")
def scriptFile  = new File(scriptsDir, "extractConfigProps.jython")
def scriptPath  = scriptFile.absolutePath

def parametersArr = []
if (propertiesFileName) {
    parametersArr << propertiesFileName
}

if (configDataKey    &&
    configDataValue)
{
    parametersArr << "-conf" << configDataKey << configDataValue
}

if (optionsKey                    &&
    optionsValue                  &&
    !optionsValue.equals("none"))
{
    parametersArr << "-opt" << optionsKey << optionsValue
}

if (filterMechanism                &&
    filterMechanism.equals("ALL"))
{
    parametersArr << "-allOpt" << filterMechanism
}
else if (filterMechanism                       &&
         filterMechanism.equals("NO_SUBTYPES") &&
         !selectedSubTypesKey                  &&
         !selectedSubTypesValue)
{
    parametersArr << "-filter" << filterMechanism
}
else if(filterMechanism                       &&
        filterMechanism.equals("NO_SUBTYPES") &&
        selectedSubTypesKey &&
        !selectedSubTypesValue)
{
    parametersArr << "-filter" << filterMechanism << "-subKey" << selectedSubTypesKey
}
else if(filterMechanism                      &&
        filterMechanism.equals("NO_SUBTYPES") &&
        selectedSubTypesKey                   &&
        selectedSubTypesValue)
{
    parametersArr << "-filter" << filterMechanism << "-subKey" << selectedSubTypesKey << "-subValue"
    parametersArr << selectedSubTypesValue
}
else if (filterMechanism                             &&
         filterMechanism.equals("SELECTED_SUBTYPES") &&
         selectedSubTypesKey                         &&
         !selectedSubTypesValue)
{
    parametersArr << "-filter" << filterMechanism << "-subKey" << selectedSubTypesKey
}
else if (filterMechanism                             &&
         filterMechanism.equals("SELECTED_SUBTYPES") &&
         selectedSubTypesKey                         &&
         selectedSubTypesValue)
{
    parametersArr << "-filter" << filterMechanism << "-subKey" << selectedSubTypesKey << "-subValue"
    parametersArr << selectedSubTypesValue
}

if (zipFileName) {
    parametersArr << "-zip" << zipFileName
}

WebSphereCmdLineHelper helper = new WebSphereCmdLineHelper(props)
helper.runWSAdminScript(scriptPath, "Extract Configuration", parametersArr.toArray(new String[0]))
