/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def cell = props['cell']
def server = props['server']
def node = props['node']
def cluster = props['cluster']
def appName = props['appName'].trim();
def appEdition = props['appEdition']
def editDesc = props['editDesc']
def context = props['context']
def location = props['location']
def path = props['path']
def argString = props['argString']
def partialUpdate = props['partialUpdate']

StringBuilder builder = new StringBuilder();
if (cluster != null && cluster.trim() != "" && !cluster.startsWith('${p:')) {
    //cluster
    builder.append("installOrUpdateApplicationInCluster(")
               .append("\"").append(location).append("\"").append(",")
               .append("\"").append(cell).append("\"").append(",")
               .append("\"").append(cluster).append("\"").append(",")
               .append("\"").append(context?:"").append("\"").append(",")
               .append("\"").append(path?:"").append("\"").append(",")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(editDesc?:"").append("\"").append(",")
               .append("\"").append(partialUpdate?:"false").append("\"").append(",")
               .append("\'").append(argString?:"").append("\'")
           .append(")")
    command = builder.toString();
}
else if (server != null && server.trim() != "" && !server.startsWith('${p:')) {
     //server
    builder.append("installOrUpdateApplicationInServer(")
               .append("\"").append(location).append("\"").append(",")
               .append("\"").append(cell).append("\"").append(",")
               .append("\"").append(server).append("\"").append(",")
               .append("\"").append(node).append("\"").append(",")
               .append("\"").append(context?:"").append("\"").append(",")
               .append("\"").append(path?:"").append("\"").append(",")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(editDesc?:"").append("\"").append(",")
               .append("\"").append(partialUpdate?:"false").append("\"").append(",")
               .append("\'").append(argString?:"").append("\'")
           .append(")")
    command = builder.toString();
}
else { /* Cell scope, -MapModulesToServers must be specified */
    if (argString.contains("-MapModulesToServers")) {
        builder.append("installOrUpdateApplicationInCell(")
               .append("\"").append(location).append("\"").append(",")
               .append("\"").append(cell).append("\"").append(",")
               .append("\"").append(context?:"").append("\"").append(",")
               .append("\"").append(path?:"").append("\"").append(",")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(editDesc?:"").append("\"").append(",")
               .append("\"").append(partialUpdate?:"false").append("\"").append(",")
               .append("\'").append(argString?:"").append("\'")
           .append(")")
        command = builder.toString();
    }
    else {
        println("The Options String field must specifiy -MapModulesToServer when no server or cluster is given!")
        sys.exit(1)
    }
}

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
