/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.websphere;

public class WebSphereAntHelper extends WebSphereCmdLineHelper {

    def antFile;

    public WebSphereAntHelper(def props) {
        super(props);
        antFile = File.createTempFile('wsant', '.xml');
        antFile.deleteOnExit();
    }

    public void runTask(def taskName, def taskClassName, def taskDef) {
        def exitCode = 0;
        println "Creating ant buildfile";
        antFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        antFile.append("\n<project name=\"proj\" default=\"" + taskName + "\">");
        antFile.append("\n    <taskdef name=\"" + taskName + "\" classname=\"" + taskClassName + "\"/>");
        antFile.append("\n    <target name=\"" + taskName + "\">");
        antFile.append("\n        " + taskDef);
        antFile.append("\n    </target>");
        antFile.append("\n</project>");
        try {
            println "Running ant task";
            println "********************************************"
            println antFile.getText()
            println "********************************************"
            runWSAntScript(antFile.absolutePath, taskName, "Run Ant Task") { it ->
                exitCode = it;
            }
        }
        finally {
            antFile.delete();
        }
        System.exit(exitCode);
    }
}
