/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def cell = props['cell']
def server = props['server']
def node = props['node']
def cluster = props['cluster']
def appName = props['appName']
def appType = props['appType']
def appEdition = props['appEdition']
File f = File.createTempFile("temp",".py")
props.setProperty("scriptFile", f.getName())
f.delete()

StringBuilder builder = new StringBuilder();
builder.append("assertApplicationIsInstalledWithEdition(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"")
           .append(")")
    .append("\n    ")
if (cluster != null && cluster.trim() != "" && !cluster.startsWith('${p:')) {
    //Check if running on cluster
    builder.append("assertApplicationIsNotRunningOnCluster(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(appType).append("\"").append(",")
               .append("\"").append(cluster).append("\"")
           .append(")")
    command = builder.toString();
}
else if (server != null && server.trim() != "" && !server.startsWith('${p:')) {
    //Check if running on server
    builder.append("assertApplicationIsNotRunningOnServer(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(appType).append("\"").append(",")
               .append("\"").append(server).append("\"").append(",")
               .append("\"").append(node).append("\"")
           .append(")")
    command = builder.toString();
}
else {
    //Check if running at cell scope
    builder.append("assertApplicationIsNotRunningOnCell(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(cell?:"").append("\"")
           .append(")")
    command = builder.toString();
}

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
