/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper
import com.urbancode.air.plugin.websphere.WebSphereFileFindHelper

def apTool                 = new AirPluginTool(this.args[0], this.args[1])
def props                  = apTool.getStepProperties()
def commandPath            = props['commandPath']?.trim()
def webSphereInstallPath   = props['webSphereInstallPath']?.trim()
def cell                   = props['cell']?.trim()
def node                   = props['node']?.trim()
def server                 = props['server']?.trim()
def user                   = props['user']?.trim()
def password               = props['password']?.trim()
def host                   = props['host']?.trim()
def port                   = props['port']?.trim()
def connType               = props['connType']?.trim()
def retryInterval          = props['retryInterval']?.trim()
def maxRetries             = props['maxRetries']?.trim()

def commandList = []
commandList << "enable"

if (node                       &&
    !node.startsWith('${p')    &&
    server                     &&
    !server.startsWith('${p'))
{
    commandList << node + ":" + server
}

if (retryInterval) {
    commandList << "-i" << retryInterval
}

if (maxRetries) {
    commandList << "-r" << maxRetries
}

if (cell) {
    commandList << "-x" << cell
}

def scriptFile = ""
if (!webSphereInstallPath                   ||
    webSphereInstallPath.startsWith('${p'))
{
    WebSphereFileFindHelper webSphereFileFinder = new WebSphereFileFindHelper(apTool.isWindows, "pluginIntelligentManagement.py")
    try {
        scriptFile = webSphereFileFinder.checkFileInPath()
    }
    catch(FileNotFoundException fe) {
        fe.printStackTrace()
        throw new RuntimeException("Process stopped as the script file is not found")
    }
}
else {
    scriptFile = webSphereInstallPath + File.separator + "bin" + File.separator + "pluginIntelligentManagement.py"
}

WebSphereCmdLineHelper cmdLineHelper = new WebSphereCmdLineHelper(props)
def result = cmdLineHelper.runWSAdminScript(
    scriptFile,
    "Enable Intelligent Management",
    commandList.toArray(new String[0]))
print result