/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.logging;

import com.ibm.icu.text.DateFormat;
import com.ibm.rational.rafw.wsadmin.RafwRuntimeException;
import com.ibm.rational.rafw.wsadmin.logging.MessageManager;
import com.ibm.rational.rafw.wsadmin.util.Globals;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogUtil {
    public static int SEVERITY_CHAR_INDEX = 9;
    public static int KEY_LENGTH = 10;
    public static final String SPACE = " ";
    public static final String TAB = "    ";
    public static final String NEW_LINE = "\n";
    public static final int MAX_STACK_TRACE_LINES = 10;
    public static final int NUM_END_LINES_STACK_TRACE = 2;
    public static final String TRACE_MESSAGE_ID = "CRWWA9998D";
    public static final String EXCEPTION_MESSAGE_ID = "CRWWA9997D";
    public static final String LOG_ERROR_MESSAGE_ID = "CRWWA9995E";
    public static final String EXCEPTION_MSG_BEGIN = "[message=";
    public static final String EXCEPTION_MSG_END = "]";
    public static final String NO_THROWABLE_MESSAGE = "[No Throwable Exception in log record]";
    public static final String FRAMEWORK_LOG_FILE_HANDLER_PROP = "java.util.logging.FileHandler.formatter";
    public static final String FRAMEWORK_LOG_FILE_HANDLER_PATTERN_PROP = "java.util.logging.FileHandler.pattern";
    public static final String HANDLERS_KEY = "handlers";
    public static final String DEBUG_WRITE_REMOTE_LOG_PROPS_FILE = "debugLeaveRemoteLogPropsFile";
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$logging$LogUtil == null ? (class$com$ibm$rational$rafw$wsadmin$logging$LogUtil = LogUtil.class$("com.ibm.rational.rafw.wsadmin.logging.LogUtil")) : class$com$ibm$rational$rafw$wsadmin$logging$LogUtil).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$logging$LogUtil;

    public static void initializeLogRun() {
        Logger logger = Logger.getLogger(CLASS_NAME + ".1", "com.ibm.rational.rafw.framework.messages.CRWFW_messages");
        logger.log(Level.SEVERE, "CRWFW0026I", new Object[]{Globals.getRunId(), LogUtil.getStartTime()});
    }

    private static String getStartTime() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance((int)2, (int)1, (Locale)Locale.getDefault());
        String string = dateFormat.format(new Date());
        return string;
    }

    public static Level getLoggerLevel(Logger logger) {
        if (null == logger) {
            return Level.INFO;
        }
        Level level = logger.getLevel();
        if (null != level) {
            return level;
        }
        return LogUtil.getLoggerLevel(logger.getParent());
    }

    public static Level mapFrameworkLevel(char c) {
        switch (c) {
            case 'D': {
                return Level.FINE;
            }
            case 'C': {
                return Level.CONFIG;
            }
            case 'I': {
                return Level.INFO;
            }
            case 'A': {
                return Level.INFO;
            }
            case 'W': {
                return Level.WARNING;
            }
            case 'E': {
                return Level.SEVERE;
            }
            case 'S': {
                return Level.SEVERE;
            }
            case 'F': {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }

    public static boolean isWsadminJVM() {
        boolean bl = false;
        Exception exception = new Exception();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (stackTraceElementArray[i].getClassName().indexOf("com.ibm.ws.scripting") <= -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static char getSeverityChar(String string) {
        char c = 'D';
        if (string.length() != KEY_LENGTH || !string.startsWith("CRW")) {
            return c;
        }
        char c2 = string.charAt(SEVERITY_CHAR_INDEX);
        switch (c2) {
            case 'A': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'I': 
            case 'S': 
            case 'W': {
                return c2;
            }
        }
        return c;
    }

    public static void closeLogHandlers() {
        Logger logger = Logger.getLogger("");
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            handlerArray[i].close();
        }
    }

    public static void flushLogHandlers() {
        int n;
        Logger logger = Logger.getLogger("com.ibm.rational.rafw.wsadmin");
        Handler[] handlerArray = logger.getHandlers();
        for (n = 0; n < handlerArray.length; ++n) {
            handlerArray[n].flush();
        }
        logger = Logger.getLogger("");
        handlerArray = logger.getHandlers();
        for (n = 0; n < handlerArray.length; ++n) {
            handlerArray[n].flush();
        }
    }

    public static boolean checkApplicableLevel(char c, String string) {
        Logger logger = Logger.getLogger(string);
        Level level = LogUtil.getLoggerLevel(logger);
        Level level2 = LogUtil.mapFrameworkLevel(c);
        return level2.intValue() >= level.intValue();
    }

    public static void printLogErr(String string) {
        if (string != null) {
            System.err.println("CRWWA9995E==>" + string);
        }
    }

    public static void printLogInitErr(String string) {
        if (string != null) {
            System.err.println("CRWWA9995E==>" + string);
        }
    }

    public static Properties getLoggingProperties(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = "Unable to locate logging properties file " + string + SPACE;
            RafwRuntimeException rafwRuntimeException = new RafwRuntimeException(string2 + fileNotFoundException.getLocalizedMessage());
            throw rafwRuntimeException;
        }
        catch (IOException iOException) {
            String string3 = "Unable to read logging properties file " + string + SPACE;
            RafwRuntimeException rafwRuntimeException = new RafwRuntimeException(string3 + iOException.getLocalizedMessage());
            throw rafwRuntimeException;
        }
        return properties;
    }

    static Level getLevelProperty(Properties properties, String string, Level level) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return level;
        }
        try {
            return Level.parse(string2.trim());
        }
        catch (Exception exception) {
            return level;
        }
    }

    public static void initializeLogManagerWithProps(Properties properties) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, null);
        }
        catch (IOException iOException) {
            String string = "Unable to store properites in ByteArrayOutputStream. " + iOException.getLocalizedMessage();
            RafwRuntimeException rafwRuntimeException = new RafwRuntimeException(string);
            throw rafwRuntimeException;
        }
        if (byteArrayOutputStream.size() <= 0) {
            throw new RafwRuntimeException("ByteArrayOutputStream for logging.properties had size <= 0");
        }
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (SecurityException securityException) {
            String string = "An SecurityException occurred initializing the LogManager. " + securityException.getLocalizedMessage();
            RafwRuntimeException rafwRuntimeException = new RafwRuntimeException(string);
            throw rafwRuntimeException;
        }
        catch (IOException iOException) {
            String string = "An IOException occurred initializing the LogManager. " + iOException.getLocalizedMessage();
            RafwRuntimeException rafwRuntimeException = new RafwRuntimeException(string);
            throw rafwRuntimeException;
        }
        LogUtil.logHandlerState();
    }

    static void logHandlerState() {
        if (logger.isLoggable(Level.CONFIG)) {
            Object object;
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Handler> arrayList2 = new ArrayList<Handler>(Arrays.asList(Logger.getLogger("").getHandlers()));
            arrayList2.addAll(Arrays.asList(Logger.getLogger("com.ibm.rational.rafw.wsadmin").getHandlers()));
            logger.log(Level.CONFIG, "CRWWA9906C", new Integer(arrayList2.size()));
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = arrayList2.get(i);
                if (object instanceof FileHandler) {
                    bl = true;
                }
                String string = object.getClass().getName();
                Formatter formatter = ((Handler)object).getFormatter();
                String string2 = " No formatter set ";
                if (formatter != null) {
                    string2 = formatter.getClass().getName();
                }
                arrayList.add(MessageManager.getExceptionMessage("com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages", "CRWWA9907C", new Object[]{string, string2}));
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (bl) {
                    logger.log(Level.CONFIG, (String)object);
                    continue;
                }
                logger.log(Level.INFO, (String)object);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

