/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper

def apTool      = new AirPluginTool(this.args[0], this.args[1])
def props       = apTool.getStepProperties()
def PLUGIN_HOME = System.getenv("PLUGIN_HOME")
def appName     = props['appName']?.trim()
def pluginHome  = new File(PLUGIN_HOME)
def scriptsDir  = new File(pluginHome, "jythonScripts")
def scriptFile  = new File(scriptsDir, "enableAutoAppStart.jython")
def scriptPath  = scriptFile.absolutePath

WebSphereCmdLineHelper helper = new WebSphereCmdLineHelper(props)
helper.runWSAdminScript(scriptPath, "Enable auto start of an application", appName)