/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def PLUGIN_HOME= System.getenv("PLUGIN_HOME");
def appName = props['appName'];
def appEdition = props['appEdition'];

def comparatorJarLocation = new File(new File(new File(PLUGIN_HOME), "lib"), "comparator.jar").absolutePath;

props['batch'] = "false";
File scriptFile = File.createTempFile("temp",".jython")
scriptFile.delete();
props['scriptFile'] = scriptFile.absolutePath;
props['additionalArgs'] = "-wsadmin_classpath\n${comparatorJarLocation}";
def command; 
StringBuilder builder = new StringBuilder();
builder.append("printApplicationDeploymentOptions(")
                   .append("'").append(appName).append("'")
                   if (appEdition) {
                        builder.append(",").append("'").append(appEdition?:"").append("'")
                   }
              builder.append(")");
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
