/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def appName = props['appName'];
def appEdition = props['appEdition'];
def appClassLoader = props['appClassLoader']?.trim();
def warClassLoader = props['warClassLoader']?.trim();
def warClassLoaderPolicy = props['warClassLoaderPolicy']?.trim();

if (appClassLoader == null || (appClassLoader != "PARENT_FIRST" && appClassLoader != "PARENT_LAST")) {
    throw new IllegalArgumentException("Application ClassLoader mode must be PARENT_FIRST or PARENT_LAST not ${appClassLoader}");
}

if (warClassLoader == null || (warClassLoader != "PARENT_FIRST" && warClassLoader != "PARENT_LAST")) {
    throw new IllegalArgumentException("WebModule ClassLoader mode must be PARENT_FIRST or PARENT_LAST not ${warClassLoader}");
}

if (warClassLoaderPolicy == null || (warClassLoaderPolicy != "SINGLE" && warClassLoaderPolicy != "MULTIPLE")) {
    throw new IllegalArgumentException("WAR ClassLoader policy must be SINGLE or MULTIPLE not ${warClassLoaderPolicy}");
}

StringBuilder builder = new StringBuilder();
builder.append("modifyClassLoaders(")
           .append("\"").append(appName).append("\"").append(",")
           .append("\"").append(appEdition?:"").append("\"").append(",")
           .append("\'").append(appClassLoader).append("\'").append(",")
           .append("\'").append(warClassLoader).append("\'").append(",")
           .append("\'").append(warClassLoaderPolicy).append("\'")
       .append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
