/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.unix;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Bits;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.unix.ModeBits;
import com.urbancode.commons.util.unix.ModeParseException;
import java.util.regex.Pattern;

@BridgeMethodsAdded
public final class UnixPermissions {
    private static final String TYPE = ".";
    private static final String READ = "(?:-|r)";
    private static final String WRITE = "(?:-|w)";
    private static final String SEXEC = "(?:-|x|s|S)";
    private static final String TEXEC = "(?:-|x|t|T)";
    private static final String EXATTR = "\\S?";
    private static final Pattern MODE_PATTERN = Pattern.compile(".(?:-|r)(?:-|w)(?:-|x|s|S)(?:-|r)(?:-|w)(?:-|x|s|S)(?:-|r)(?:-|w)(?:-|x|t|T)\\S?");
    private final int mode;
    private final String user;
    private final String group;

    public static UnixPermissions createFromNumeric(int mode, String user, String group) {
        return new UnixPermissions(mode, user, group);
    }

    public static UnixPermissions createFromText(String mode, String user, String group) throws ModeParseException {
        Check.nonNull(mode, "mode");
        return UnixPermissions.createFromNumeric(UnixPermissions.parseTextMode(mode.trim()), user, group);
    }

    public static UnixPermissions createFromOctal(String mode, String user, String group) throws ModeParseException {
        Check.nonNull(mode, "mode");
        try {
            int numericMode = Integer.parseInt(mode.trim(), 8);
            return UnixPermissions.createFromNumeric(numericMode, user, group);
        }
        catch (NumberFormatException e) {
            throw new ModeParseException("Invalid mode: " + mode, e);
        }
    }

    static String toOctal(int mode) {
        return String.format("%04o", mode);
    }

    static int parseTextMode(String modeStr) throws ModeParseException {
        if (!MODE_PATTERN.matcher(modeStr).matches()) {
            throw new ModeParseException("Invalid mode: " + modeStr);
        }
        int mode = 0;
        char ur = modeStr.charAt(1);
        char uw = modeStr.charAt(2);
        char ux = modeStr.charAt(3);
        char gr = modeStr.charAt(4);
        char gw = modeStr.charAt(5);
        char gx = modeStr.charAt(6);
        char or = modeStr.charAt(7);
        char ow = modeStr.charAt(8);
        char ox = modeStr.charAt(9);
        mode = Bits.set(mode, 2048, ux == 'S' || ux == 's');
        mode = Bits.set(mode, 1024, gx == 'S' || gx == 's');
        mode = Bits.set(mode, 512, ox == 'T' || ox == 't');
        mode = Bits.set(mode, 256, ur == 'r');
        mode = Bits.set(mode, 128, uw == 'w');
        mode = Bits.set(mode, 64, ux == 'x' || ux == 's');
        mode = Bits.set(mode, 32, gr == 'r');
        mode = Bits.set(mode, 16, gw == 'w');
        mode = Bits.set(mode, 8, gx == 'x' || gx == 's');
        mode = Bits.set(mode, 4, or == 'r');
        mode = Bits.set(mode, 2, ow == 'w');
        mode = Bits.set(mode, 1, ox == 'x' || ox == 't');
        return mode;
    }

    private UnixPermissions(int mode, String user, String group) {
        if (mode < 0 || mode > 4095) {
            throw new IllegalArgumentException(String.format("Invalid mode %04o", mode));
        }
        this.mode = mode;
        this.user = Check.nonNull(user, "user").trim();
        this.group = Check.nonNull(group, "group").trim();
    }

    public String toString() {
        return this.getTextMode() + " " + this.getUser() + ":" + this.getGroup();
    }

    public int getMode() {
        return this.mode;
    }

    public String getOctalMode() {
        return UnixPermissions.toOctal(this.getMode());
    }

    public String getTextMode() {
        StringBuilder builder = new StringBuilder();
        builder.append('-');
        builder.append(this.isUserReadable() ? (char)'r' : '-');
        builder.append(this.isUserWritable() ? (char)'w' : '-');
        if (this.isUserExecutable() && this.isSetUid()) {
            builder.append('s');
        } else if (this.isUserExecutable()) {
            builder.append('x');
        } else if (this.isSetUid()) {
            builder.append('S');
        } else {
            builder.append('-');
        }
        builder.append(this.isGroupReadable() ? (char)'r' : '-');
        builder.append(this.isGroupWritable() ? (char)'w' : '-');
        if (this.isGroupExecutable() && this.isSetGid()) {
            builder.append('s');
        } else if (this.isGroupExecutable()) {
            builder.append('x');
        } else if (this.isSetGid()) {
            builder.append('S');
        } else {
            builder.append('-');
        }
        builder.append(this.isOtherReadable() ? (char)'r' : '-');
        builder.append(this.isOtherWritable() ? (char)'w' : '-');
        if (this.isOtherExecutable() && this.isSticky()) {
            builder.append('t');
        } else if (this.isOtherExecutable()) {
            builder.append('x');
        } else if (this.isSticky()) {
            builder.append('T');
        } else {
            builder.append('-');
        }
        return builder.toString();
    }

    public String getUser() {
        return this.user;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isSetUid() {
        return ModeBits.isSetUid(this.getMode());
    }

    public boolean isSetGid() {
        return ModeBits.isSetGid(this.getMode());
    }

    public boolean isSticky() {
        return ModeBits.isSticky(this.getMode());
    }

    public boolean isUserReadable() {
        return ModeBits.isUserReadable(this.getMode());
    }

    public boolean isUserWritable() {
        return ModeBits.isUserWritable(this.getMode());
    }

    public boolean isUserExecutable() {
        return ModeBits.isUserExecutable(this.getMode());
    }

    public boolean isGroupReadable() {
        return ModeBits.isGroupReadable(this.getMode());
    }

    public boolean isGroupWritable() {
        return ModeBits.isGroupWritable(this.getMode());
    }

    public boolean isGroupExecutable() {
        return ModeBits.isGroupExecutable(this.getMode());
    }

    public boolean isOtherReadable() {
        return ModeBits.isOtherReadable(this.getMode());
    }

    public boolean isOtherWritable() {
        return ModeBits.isOtherWritable(this.getMode());
    }

    public boolean isOtherExecutable() {
        return ModeBits.isOtherExecutable(this.getMode());
    }
}

