/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.performance;

import com.ibm.rational.rafw.wsadmin.performance.PerfData;
import com.ibm.rational.rafw.wsadmin.util.Globals;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Performance {
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$performance$Performance == null ? (class$com$ibm$rational$rafw$wsadmin$performance$Performance = Performance.class$("com.ibm.rational.rafw.wsadmin.performance.Performance")) : class$com$ibm$rational$rafw$wsadmin$performance$Performance).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    public static final String RAF_SH = "raf main method";
    private static Map performanceMetrics = new HashMap();
    private static Stack callStack = new Stack();
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$performance$Performance;

    public static final void start(String string) {
        if (Performance.isEnabled()) {
            if (!performanceMetrics.containsKey(string)) {
                performanceMetrics.put(string, new PerfData(string));
            }
            PerfData perfData = (PerfData)performanceMetrics.get(string);
            if (!callStack.isEmpty()) {
                PerfData perfData2 = (PerfData)callStack.peek();
                perfData2.addChildTask(perfData);
                perfData.start(perfData2);
            } else {
                perfData.start();
            }
            callStack.push(perfData);
        }
    }

    public static final void end(String string) {
        if (Performance.isEnabled()) {
            PerfData perfData;
            if (!performanceMetrics.containsKey(string)) {
                logger.log(Level.FINE, "Ignoring performance end time for '" + string + "': 'end' called without calling 'start'");
                return;
            }
            PerfData perfData2 = (PerfData)performanceMetrics.get(string);
            if (!(callStack.isEmpty() || perfData2.equals(perfData = (PerfData)callStack.pop()) || callStack.isEmpty())) {
                perfData = (PerfData)callStack.pop();
            }
            perfData2.end();
        }
    }

    private static boolean isEnabled() {
        return logger.isLoggable(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void displayMetrics() {
        block12: {
            if (Performance.isEnabled()) {
                BufferedWriter bufferedWriter = null;
                try {
                    Serializable serializable;
                    String string;
                    String string2 = System.getProperty("LOG_HOME");
                    if (Globals.isEmpty(string2)) {
                        string = System.getProperty("WSADMIN_LOG");
                        if (Globals.isEmpty(string)) {
                            string2 = Globals.getInstallRoot() + "/logs";
                        } else {
                            serializable = new File(string);
                            string2 = ((File)serializable).getParent();
                        }
                    }
                    string = string2 + "/perf/" + Globals.getRunId() + ".tsv";
                    logger.log(Level.INFO, "Writing performance data to file '" + string + "'");
                    bufferedWriter = Performance.newWriter(string, true);
                    serializable = new TreeSet(performanceMetrics.keySet());
                    bufferedWriter.write(Performance.joinStrings(new String[]{"Category", "Low (MS)", "High (MS)", "Total Calls", "Total Time", "Average (MS)", "Total Time in Child Tasks", "Average Less Child Tasks (MS)", "Methods called by this method", "Ordered List of Time Per Invocation"}, "\t"));
                    bufferedWriter.newLine();
                    Iterator iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        PerfData perfData = (PerfData)performanceMetrics.get(string3);
                        bufferedWriter.write(Performance.joinStrings(new String[]{perfData.getDisplayName(), Long.toString(perfData.getLowest()), Long.toString(perfData.getHighest()), Integer.toString(perfData.getCount()), Long.toString(perfData.getTotalTime()), Double.toString(perfData.getAverage()), Long.toString(perfData.getChildTaskTotalTime()), Double.toString(perfData.getAverageLessChildTask()), perfData.getChildTaskNames(), perfData.getOrderedTimes()}, "\t"));
                        bufferedWriter.newLine();
                    }
                    Performance.closeFile(bufferedWriter);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.log(Level.FINE, "Unable to gather performance metrics: ", fileNotFoundException);
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Unable to gather performance metrics: ", iOException);
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Performance.closeFile(bufferedWriter);
                }
            }
        }
    }

    static String joinStrings(String[] stringArray, String string) {
        if (stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(stringArray.length * 25);
            stringBuffer.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(stringArray[i]);
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private static void closeFile(BufferedWriter bufferedWriter) {
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    private static BufferedWriter newWriter(String string, boolean bl) throws FileNotFoundException {
        File file = new File(string);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        return new BufferedWriter(outputStreamWriter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

