/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import java.util.Map
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def PLUGIN_HOME= System.getenv("PLUGIN_HOME");
def name = props['name'];
def cuName = props['cuName'];
def edition = props['edition']?.trim();
def pluginHome = new File(PLUGIN_HOME);
def scriptsDir = new File(pluginHome, "jythonScripts")
def scriptFile = new File(scriptsDir, "checkCUExists.jython");
def scriptPath = scriptFile.absolutePath; 
def outputProps = new Properties();
def exitValue = 0;
def exitCodeChecker = { exitCode ->
    if (exitCode == 0) {
        outputProps.setProperty("cuExists", "true");
        exitValue = 0;
    }
    else if (exitCode == 30) {
        outputProps.setProperty("cuExists", "false");
        exitValue = 0;
    }
    else {
        outputProps.setProperty("cuExists", "unknown");
        exitValue = 1;
    }
}
def args = [];
args << name;
args << cuName;
if (edition != null && edition != "") {
    args << edition;
}

WebSphereCmdLineHelper helper = new WebSphereCmdLineHelper(props);
helper.runWSAdminScript(scriptPath, "Checking BLA", exitCodeChecker, args as String[]);

//persist outputProps
for (Map.Entry<String, String> e : outputProps.entrySet()) {
    print "Setting outputProperty ${e.getKey()} with value ${e.getValue()}"
    apTool.setOutputProperty(e.getKey(), e.getValue());
}
apTool.setOutputProperties();
System.exit(exitValue);
