/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def appName = props['appName']
def appEdition = props['appEdition']
def groupSize = props['groupSize']
def resetStrategy = props['resetStrategy']
def drainageInterval = props['drainageInterval']
def quiesceInterval = props['quiesceInterval']

StringBuilder builder = new StringBuilder();
builder.append("groupRolloutEdition(")
           .append("\"").append(appName).append("\"").append(",")
           .append("\"").append(appEdition?:"").append("\"").append(",")
           .append("\"").append(groupSize).append("\"").append(",")
           .append("\"").append(resetStrategy).append("\"").append(",")
           .append("\"").append(drainageInterval).append("\"");
           if (quiesceInterval != null && quiesceInterval.trim() != "") {
               builder.append(",").append("\"").append(quiesceInterval).append("\"")
           }
       builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
