/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereAntHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def ear = props['ear'].trim();
def outputEar = props['outputEar'].trim();
def defaultDataSource = props['defaultDataSource'].trim();
def dbUser = props['dbUser'].trim();
def dbPassword = props['dbPassword'].trim();
def defaultConnectionFactory = props['defaultConnectionFactory'].trim();
def resAuth = props['resAuth'].trim();
def ejbJndiPrefix = props['ejbJndiPrefix'].trim();
def virtualHost = props['virtualHost'].trim();
def forceBindings = props['forceBindings'].trim();
def strategy = props['strategy'].trim();
def failonerror = props['failonerror'].trim();
def exportFile = props['exportFile'].trim();

def taskName = "wsDefaultBindings";
def taskClassName = "com.ibm.websphere.ant.tasks.DefaultBindings";
StringBuilder taskDef = new StringBuilder();

taskDef.append("<wsDefaultBindings ear=\"" + ear + "\" outputFile=\"" + outputEar + "\"");

if (defaultDataSource != null && defaultDataSource != "") {
    taskDef.append(" defaultDataSource=\"" + defaultDataSource + "\"");
}

if (dbUser != null && dbUser != "") {
    taskDef.append(" dbUser=\"" + dbUser + "\"");
}

if (dbPassword != null && dbPassword != "") {
    taskDef.append(" dbPassword=\"" + dbPassword + "\"");
}

if (defaultConnectionFactory != null && defaultConnectionFactory != "") {
    taskDef.append(" defaultConnectionFactory=\"" + defaultConnectionFactory + "\"");
}

if (resAuth != null && resAuth != "") {
    taskDef.append(" resAuth=\"" + resAuth + "\"");
}

if (ejbJndiPrefix != null && ejbJndiPrefix != "") {
    taskDef.append(" ejbJndiPrefix=\"" + ejbJndiPrefix + "\"");
}

if (virtualHost != null && virtualHost != "") {
    taskDef.append(" virtualHost=\"" + virtualHost + "\"");
}

if ( forceBindings != null && forceBindings != "") {
    taskDef.append(" forceBindings=\"" + forceBindings + "\"");
}

if (strategy != null && strategy != "") {
    taskDef.append(" strategy=\"" + strategy + "\"");
}

if (failonerror != null && failonerror != "") {
    taskDef.append(" failonerror=\"" + failonerror + "\"");
}

if (exportFile != null && exportFile != "") {
    taskDef.append(" exportFile=\"" + exportFile + "\"");
}

taskDef.append(" />");

WebSphereAntHelper anthelper = new WebSphereAntHelper(props);
anthelper.runTask(taskName, taskClassName, taskDef.toString());
