/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper
import com.urbancode.air.plugin.websphere.WebSphereFileFindHelper

def apTool                      = new AirPluginTool(this.args[0], this.args[1])
def props                       = apTool.getStepProperties()
def commandPath                 = props['commandPath']?.trim()
def webSphereInstallPath        = props['webSphereInstallPath']?.trim()
def node                        = props['node']?.trim()
def server                      = props['server']?.trim()
def user                        = props['user']?.trim()
def password                    = props['password']?.trim()
def host                        = props['host']?.trim()
def port                        = props['port']?.trim()
def connType                    = props['connType']?.trim()
def remoteCellHost              = props['remoteCellHost']?.trim()
def remoteCellPort              = props['remoteCellPort']?.trim()
def deleteCertificates          = props['deleteCertificates']?.trim()

def commandList = []
commandList << "deleteRemoteCell"

if (node                       &&
    !node.startsWith('${p')    &&
    server                     &&
    !server.startsWith('${p'))
{
    commandList << node + ":" + server
}

if (remoteCellHost) {
    commandList << remoteCellHost
}

if (remoteCellPort) {
    commandList << remoteCellPort
}

if (deleteCertificates) {
    commandList << deleteCertificates
}

def scriptFile = ""
if (!webSphereInstallPath                   ||
    webSphereInstallPath.startsWith('${p'))
{
    WebSphereFileFindHelper webSphereFileFinder = new WebSphereFileFindHelper(apTool.isWindows, "pluginIntelligentManagement.py")
    try {
        scriptFile = webSphereFileFinder.checkFileInPath()
    }
    catch(FileNotFoundException fe) {
        fe.printStackTrace()
        throw new RuntimeException("Process stopped as the script file is not found")
    }
}
else {
    scriptFile = webSphereInstallPath + File.separator + "bin" + File.separator + "pluginIntelligentManagement.py"
}

WebSphereCmdLineHelper cmdLineHelper = new WebSphereCmdLineHelper(props)
def result = cmdLineHelper.runWSAdminScript(
    scriptFile,
    "Delete Remote Cell",
    commandList.toArray(new String[0]))
print result