/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.logging;

import com.ibm.rational.rafw.wsadmin.RafwRuntimeException;
import com.ibm.rational.rafw.wsadmin.logging.FrameworkFormatter;
import com.ibm.rational.rafw.wsadmin.logging.LogUtil;
import com.ibm.rational.rafw.wsadmin.logging.TraceFormatter;
import com.ibm.rational.rafw.wsadmin.logging.WsAdminConsoleHandler;
import com.ibm.rational.rafw.wsadmin.util.Globals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.server.UID;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class ClientLogManager {
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager == null ? (class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager = ClientLogManager.class$("com.ibm.rational.rafw.wsadmin.logging.ClientLogManager")) : class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    public static final String WSADMIN_LOG_NAME_PREFIX = "com.ibm.rational.rafw.wsadmin";
    public static final String SYS_PROP_WSADMIN_LOG = "WSADMIN_LOG";
    public static final String SYS_PROP_TARGET = "TARGET";
    public static final String REQ_SYS_PROP_LOG_HOME = "LOG_HOME";
    private static final List handlersLoaded = new LinkedList();
    public static final int DEFAULT_ACTION_LOG_COUNT = 1;
    public static final int DEFAULT_ACTION_LOG_LIMIT = 50000;
    public static boolean DEFAULT_ACTION_LOG_APPEND = true;
    private static Properties props = null;
    private static String jvmUID = null;
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager;

    public static void initializeLogger() {
        try {
            if (jvmUID == null) {
                jvmUID = new UID().toString();
                jvmUID = jvmUID.replaceAll(":", "_");
                jvmUID = jvmUID.replaceAll("-", "");
                if (!ClientLogManager.isServerJVM()) {
                    ClientLogManager.initializeClientLogger();
                } else {
                    return;
                }
            }
            if (ClientLogManager.appendFileHandler()) {
                LogUtil.logHandlerState();
            }
        }
        catch (Exception exception) {
            LogUtil.printLogInitErr("Initialzation of RAFW logger failed : " + exception.getLocalizedMessage());
        }
    }

    private static boolean appendFileHandler() {
        String string = ClientLogManager.getLogFileLocation();
        if (ClientLogManager.isHandlerLoaded(string)) {
            return false;
        }
        Logger logger = Logger.getLogger("");
        try {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            int n = ClientLogManager.getActionLogLimit();
            int n2 = ClientLogManager.getActionLogCount();
            boolean bl = ClientLogManager.getActionLogAppend();
            FileHandler fileHandler = new FileHandler(string, n, n2, bl);
            TraceFormatter traceFormatter = new TraceFormatter();
            fileHandler.setFormatter(traceFormatter);
            logger.addHandler(fileHandler);
            ClientLogManager.addAttachedHandler(string);
            ClientLogManager.logger.log(Level.CONFIG, "CRWWA9905C", new Object[]{string, new Integer(n), new Integer(n2), new Boolean(bl)});
        }
        catch (SecurityException securityException) {
            String string2 = "A SecurityException occurred setting a TraceFormatter for file " + string;
            logger.warning(string2);
            logger.throwing((class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager == null ? (class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager = ClientLogManager.class$("com.ibm.rational.rafw.wsadmin.logging.ClientLogManager")) : class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager).getName(), "initializeLogger", securityException);
        }
        catch (IOException iOException) {
            String string3 = "A IOException occurred setting a TraceFormatter for file " + string;
            logger.warning(string3);
            logger.throwing((class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager == null ? (class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager = ClientLogManager.class$("com.ibm.rational.rafw.wsadmin.logging.ClientLogManager")) : class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager).getName(), "initializeLogger", iOException);
        }
        return true;
    }

    private static String getLogFileLocation() {
        String string;
        String string2 = System.getProperty(SYS_PROP_WSADMIN_LOG);
        if (!Globals.isEmpty(string2)) {
            return string2;
        }
        Logger logger = Logger.getLogger("");
        String string3 = System.getProperty(REQ_SYS_PROP_LOG_HOME);
        if (string3 == null) {
            string3 = Globals.getInstallRoot() + File.separatorChar + "logs";
            string = "LOG_HOME was not set when attempting to initialize ant logging.  Using default path: " + string3;
            logger.log(Level.INFO, string);
        }
        if (Globals.isEmpty(string = System.getProperty(SYS_PROP_TARGET))) {
            string = "transfer";
        }
        String string4 = string3 + File.separatorChar + string + ".trace";
        return string4;
    }

    private static boolean isServerJVM() {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getLogger("");
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            if (handlerArray[i] instanceof ConsoleHandler && handlerArray[i].getFormatter() instanceof FrameworkFormatter) {
                bl = true;
            }
            if (!(handlerArray[i] instanceof FileHandler) || !(handlerArray[i].getFormatter() instanceof TraceFormatter)) continue;
            bl2 = true;
        }
        ClientLogManager.logger.log(Level.CONFIG, "CRWWA9908C", new Object[]{new Boolean(bl), new Boolean(bl2)});
        return bl && bl2;
    }

    private static void initializeClientLogger() {
        boolean bl;
        String string;
        if (jvmUID == null) {
            throw new IllegalStateException("jvmUID is null, but initializeClientLogger was called");
        }
        File file = new File(Globals.getInstallRoot() + File.separator + "logging.properties");
        Properties properties = LogUtil.getLoggingProperties(file.getAbsolutePath());
        boolean bl2 = false;
        if (properties.containsKey("debugLeaveRemoteLogPropsFile")) {
            bl2 = true;
        }
        if (Globals.isEmpty(string = properties.getProperty("handlers"))) {
            if (bl2) {
                ClientLogManager.writeClientLogFile(properties);
            }
            String string2 = "Unable to find the \"handlers\" property in the client log file.  Set the debugLeaveRemoteLogPropsFile property in the logging.properties file to have the client logging.properties file written to disk";
            throw new IllegalStateException(string2);
        }
        properties.setProperty("handlers", "java.util.logging.ConsoleHandler");
        properties.remove("java.util.logging.FileHandler.formatter");
        if (bl2) {
            ClientLogManager.writeClientLogFile(properties);
        }
        if (bl = LogUtil.isWsadminJVM()) {
            ClientLogManager.setLogLevels(properties);
            ClientLogManager.fixOrAddConsoleHandler();
        } else {
            LogUtil.initializeLogManagerWithProps(properties);
        }
    }

    private static void loadLoggingProps() {
        if (props == null) {
            Logger logger = Logger.getLogger("");
            String string = Globals.getInstallRoot();
            props = new Properties();
            try {
                props.load(new FileInputStream(new File(string + File.separator + "logging.properties")));
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.throwing((class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager == null ? (class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager = ClientLogManager.class$("com.ibm.rational.rafw.wsadmin.logging.ClientLogManager")) : class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager).getName(), "loadLoggingProps", fileNotFoundException);
                throw new RafwRuntimeException("FNFE, Unable to load logging.properties");
            }
            catch (IOException iOException) {
                logger.throwing((class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager == null ? (class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager = ClientLogManager.class$("com.ibm.rational.rafw.wsadmin.logging.ClientLogManager")) : class$com$ibm$rational$rafw$wsadmin$logging$ClientLogManager).getName(), "loadLoggingProps", iOException);
                throw new RafwRuntimeException("IOException, unable to load logging.properties");
            }
        }
    }

    static void setLoggingProps(Properties properties) {
        props = properties;
    }

    public static boolean isHandlerLoaded(String string) {
        return handlersLoaded.contains(string);
    }

    public static Level getEffectiveLogLevel(String string) {
        ClientLogManager.loadLoggingProps();
        while (string.length() > 0) {
            String string2 = string + ".level";
            Level level = LogUtil.getLevelProperty(props, string2, null);
            if (level != null) {
                return level;
            }
            if (string.lastIndexOf(".") > -1) {
                string = string.substring(0, string.lastIndexOf(46));
                continue;
            }
            string = "";
        }
        return LogUtil.getLevelProperty(props, ".level", Level.INFO);
    }

    private static void addAttachedHandler(String string) {
        handlersLoaded.add(string);
    }

    private static boolean getActionLogAppend() {
        ClientLogManager.loadLoggingProps();
        String string = (String)props.get("actionlog.append");
        boolean bl = DEFAULT_ACTION_LOG_APPEND;
        if (string != null) {
            bl = !string.toUpperCase().equals("FALSE");
        }
        return bl;
    }

    private static int getActionLogLimit() {
        ClientLogManager.loadLoggingProps();
        String string = (String)props.get("actionlog.limit");
        int n = 50000;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Unable to parse integer for value of actionlog.limit");
            }
        }
        return n;
    }

    private static int getActionLogCount() {
        ClientLogManager.loadLoggingProps();
        String string = (String)props.get("actionlog.count");
        int n = 1;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Unable to parse integer for value of actionlog.count");
            }
        }
        return n;
    }

    private static void writeClientLogFile(Properties properties) {
        int n = Math.abs(new Random().nextInt());
        String string = Globals.getInstallRoot() + File.separator + "work" + File.separator + "logging.properties_" + n;
        System.out.println("Saving target system log file to " + string);
        try {
            properties.store(new FileOutputStream(new File(string)), "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = "A FileNotFoundException was thrown trying to save the client logging.properties file. Message: " + fileNotFoundException.getLocalizedMessage();
            throw new RafwRuntimeException(string2);
        }
        catch (IOException iOException) {
            String string3 = "An IOException was thrown trying to save the client logging.properties file.  Message: " + iOException.getLocalizedMessage();
            throw new RafwRuntimeException(string3);
        }
    }

    private static void setLogLevels(Properties properties) {
        String string = "setLogLevels";
        logger.entering(CLASS_NAME, string, new Object[]{properties});
        LogManager logManager = LogManager.getLogManager();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.endsWith(".level")) continue;
            int n = string2.length() - 6;
            String string3 = string2.substring(0, n);
            Level level = LogUtil.getLevelProperty(properties, string2, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + string2);
                continue;
            }
            Logger logger = logManager.getLogger(string3);
            if (logger == null) {
                logger = Logger.getLogger(string3);
            }
            logger.setLevel(level);
        }
        logger.exiting(CLASS_NAME, string);
    }

    private static void fixOrAddConsoleHandler() {
        String string = "fixOrAddConsoleHandler";
        logger.entering(CLASS_NAME, string);
        Logger logger = Logger.getLogger(WSADMIN_LOG_NAME_PREFIX);
        Handler[] handlerArray = logger.getHandlers();
        boolean bl = false;
        for (int i = 0; i < handlerArray.length; ++i) {
            if (!(handlerArray[i] instanceof ConsoleHandler)) continue;
            bl = true;
            logger.removeHandler(handlerArray[i]);
            WsAdminConsoleHandler wsAdminConsoleHandler = new WsAdminConsoleHandler();
            wsAdminConsoleHandler.setFormatter(new FrameworkFormatter());
            wsAdminConsoleHandler.setLevel(Level.INFO);
            logger.addHandler(wsAdminConsoleHandler);
        }
        if (!bl) {
            WsAdminConsoleHandler wsAdminConsoleHandler = new WsAdminConsoleHandler();
            wsAdminConsoleHandler.setLevel(Level.INFO);
            wsAdminConsoleHandler.setFormatter(new FrameworkFormatter());
            logger.addHandler(wsAdminConsoleHandler);
        }
        LogUtil.logHandlerState();
        ClientLogManager.logger.exiting(CLASS_NAME, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

