/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.logging;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageManager {
    public static final String RB_SERVICES = "com.ibm.rational.raf.services.messages.CRWSE_messages";
    public static final String RB_FRAMEWORK = "com.ibm.rational.rafw.framework.messages.CRWFW_messages";
    public static final String RB_WEB = "com.ibm.rafw.servlets.messages.CRWEB_messages";
    public static final String RB_CLIENT = "com.ibm.rational.raf.client.common.messages.CRWCC_messages";
    public static final String RB_WEBSPHERE_BPM = "com.ibm.rational.rafw.wsadmin.messages.CRWBP_messages";
    public static final String RB_WEBSPHERE_IHS = "com.ibm.rational.rafw.wsadmin.messages.CRWIH_messages";
    public static final String RB_WEBSPHERE_WVE = "com.ibm.rational.rafw.wsadmin.messages.CRWVE_messages";
    public static final String RB_WEBSPHERE_WAS = "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages";
    public static final String RB_WEBSPHERE_WP = "com.ibm.rational.rafw.wsadmin.messages.CRWWP_messages";
    public static final String RB_WIZARD_EXISTING = "com.ibm.rational.raf.environment.wizard.bundles.ExistingCellEnvGenResourceBundle";
    public static final String RB_WIZARD_NEW = "com.ibm.rational.raf.environment.wizard.bundles.EnvGenResourceBundle";
    public static final String RB_INTEGRATE_BF = "com.ibm.rational.bfw.framework.integration.messages.IntegrateToBF_messages";
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$logging$MessageManager == null ? (class$com$ibm$rational$rafw$wsadmin$logging$MessageManager = MessageManager.class$("com.ibm.rational.rafw.wsadmin.logging.MessageManager")) : class$com$ibm$rational$rafw$wsadmin$logging$MessageManager).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    private static Pattern regex = Pattern.compile(".*\\{\\d+\\}.*", 32);
    public static final String UNKOWN_MESSAGE_ID = "CRWWA9999W";
    public static final String LEGACY_MESSAGE_ID_INFO = "CRWWA9902I";
    public static final String LEGACY_MESSAGE_ID_WARNING = "CRWWA9903W";
    public static final String LEGACY_MESSAGE_ID_SEVERE = "CRWWA9904E";
    private static final String NEW_LINE = System.getProperty("line.separator");
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$logging$MessageManager;

    private MessageManager() {
    }

    public static String getExceptionMessage(String string, String string2, Object[] objectArray) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            Matcher matcher = regex.matcher(resourceBundle.getString(string2));
            if (matcher.find()) {
                return MessageFormat.format(resourceBundle.getString(string2), objectArray);
            }
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            logger.log(Level.FINE, missingResourceException.toString(), missingResourceException);
            String string3 = "";
            if (objectArray != null && objectArray.length > 0) {
                string3 = " " + Arrays.asList(objectArray).toString();
            }
            return string2 + string3;
        }
    }

    public static String getLocalizedMessage(String string, Locale locale, String string2, Object[] objectArray) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            if (string2 == null) {
                return null;
            }
            Matcher matcher = regex.matcher(resourceBundle.getString(string2));
            if (matcher.find()) {
                return MessageFormat.format(resourceBundle.getString(string2), objectArray);
            }
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            logger.log(Level.FINE, missingResourceException.toString(), missingResourceException);
            String string3 = "";
            if (objectArray != null && objectArray.length > 0) {
                string3 = " " + Arrays.asList(objectArray).toString();
            }
            return string2 + string3;
        }
    }

    public static String getExceptionMessage(String string, String string2, Object object) {
        return MessageManager.getExceptionMessage(string, string2, new Object[]{object});
    }

    public static String getFormattedList(List list) {
        StringBuffer stringBuffer = new StringBuffer(list.size() * 30);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("   ");
            stringBuffer.append(iterator.next());
            stringBuffer.append(NEW_LINE);
        }
        return stringBuffer.toString();
    }

    public static String getMessage(String string, String string2) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            logger.log(Level.FINE, missingResourceException.toString(), missingResourceException);
            return string2;
        }
    }

    public static String getInvalidMessage(String string) {
        return MessageManager.getExceptionMessage(RB_WEBSPHERE_WAS, UNKOWN_MESSAGE_ID, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

