/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.util;

import com.ibm.rational.rafw.wsadmin.util.Globals;
import com.ibm.rational.rafw.wsadmin.util.WsadminStringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WsadminPropertiesUtil
implements Serializable {
    private static final long serialVersionUID = -1085084366977106281L;
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$util$WsadminPropertiesUtil == null ? (class$com$ibm$rational$rafw$wsadmin$util$WsadminPropertiesUtil = WsadminPropertiesUtil.class$("com.ibm.rational.rafw.wsadmin.util.WsadminPropertiesUtil")) : class$com$ibm$rational$rafw$wsadmin$util$WsadminPropertiesUtil).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    private List lines = new ArrayList();
    private Map properties = new HashMap();
    private String propertyFileAbsPath = null;
    private String encoding = null;
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$util$WsadminPropertiesUtil;

    public static final WsadminPropertiesUtil getInstance(String string) throws FileNotFoundException, IOException {
        WsadminPropertiesUtil wsadminPropertiesUtil = new WsadminPropertiesUtil();
        wsadminPropertiesUtil.load(string);
        return wsadminPropertiesUtil;
    }

    public static final WsadminPropertiesUtil getInstance(File file) throws FileNotFoundException, IOException {
        WsadminPropertiesUtil wsadminPropertiesUtil = new WsadminPropertiesUtil();
        wsadminPropertiesUtil.load(file);
        return wsadminPropertiesUtil;
    }

    public static final WsadminPropertiesUtil getInstance(File file, String string) throws FileNotFoundException, IOException {
        WsadminPropertiesUtil wsadminPropertiesUtil = new WsadminPropertiesUtil();
        wsadminPropertiesUtil.setEncoding(string);
        wsadminPropertiesUtil.load(file);
        return wsadminPropertiesUtil;
    }

    public void load(String string) throws FileNotFoundException, IOException {
        if (null == string) {
            throw new IllegalArgumentException("Argument '" + string + "' must not be blank or null");
        }
        this.propertyFileAbsPath = string;
        this.load(new FileInputStream(string));
    }

    public void load(File file) throws FileNotFoundException, IOException {
        if (null == file) {
            throw new IllegalArgumentException("Argument '" + file + "' must not be blank or null");
        }
        this.propertyFileAbsPath = file.getAbsolutePath();
        this.load(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(FileInputStream fileInputStream) throws FileNotFoundException, IOException {
        if (null == fileInputStream) {
            throw new IllegalArgumentException("Argument '" + fileInputStream + "' must not be blank or null");
        }
        BufferedReader bufferedReader = null;
        boolean bl = false;
        try {
            bufferedReader = this.newReader(fileInputStream, this.getEncoding());
            this.lines = new ArrayList();
            this.properties = new HashMap();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                this.lines.add(string);
                if (string.matches("[\\s#]+.*")) continue;
                String[] stringArray = this.getKeyValuePair(string);
                if (stringArray != null && stringArray.length == 2) {
                    this.properties.put(stringArray[0], stringArray[1]);
                    continue;
                }
                if (stringArray == null || stringArray.length != 1) continue;
                this.properties.put(stringArray[0], "");
            }
        }
        catch (IOException iOException) {
            bl = true;
            logger.logp(Level.WARNING, CLASS_NAME, "load", "CRWWA0006W", iOException);
        }
        finally {
            this.close(bufferedReader, bl);
        }
    }

    private void close(Reader reader, boolean bl) throws IOException {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            if (bl) {
                logger.log(Level.WARNING, "CRWWA0500W", iOException);
            }
            throw iOException;
        }
    }

    public void setFile(File file) {
        this.propertyFileAbsPath = file.getAbsolutePath();
    }

    public void store() throws IOException {
        boolean bl;
        BufferedWriter bufferedWriter;
        block6: {
            block5: {
                if (WsadminStringUtils.isEmpty(this.propertyFileAbsPath)) break block5;
                bufferedWriter = null;
                bl = false;
                try {
                    bufferedWriter = this.newWriter(this.propertyFileAbsPath, this.encoding);
                    Iterator iterator = this.lines.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                }
                catch (IOException iOException) {
                    try {
                        bl = true;
                        throw iOException;
                    }
                    catch (Throwable throwable) {
                        this.close(bufferedWriter, bl);
                        throw throwable;
                    }
                }
                break block6;
            }
            throw new IllegalStateException("propertyFile must be set in order to store these properties");
        }
        this.close(bufferedWriter, bl);
    }

    public void append(String string) throws IOException {
        this.propertyFileAbsPath = string;
        BufferedWriter bufferedWriter = null;
        boolean bl = false;
        try {
            bufferedWriter = this.newWriter(this.propertyFileAbsPath, null, true);
            Iterator iterator = this.lines.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            try {
                bl = true;
                throw iOException;
            }
            catch (Throwable throwable) {
                this.close(bufferedWriter, bl);
                throw throwable;
            }
        }
        this.close(bufferedWriter, bl);
    }

    private void close(Writer writer, boolean bl) throws IOException {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            if (bl) {
                logger.log(Level.WARNING, "CRWWA0501W", iOException);
            }
            throw iOException;
        }
    }

    private BufferedWriter newWriter(String string, String string2) throws IOException {
        Charset charset = Charset.forName(this.getEncoding());
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Unable to create directory: " + file2.getAbsolutePath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        return bufferedWriter;
    }

    private BufferedWriter newWriter(String string, String string2, boolean bl) throws IOException {
        Charset charset = Charset.forName(this.getEncoding());
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Unable to create directory: " + file2.getAbsolutePath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        return bufferedWriter;
    }

    private String[] getKeyValuePair(String string) {
        String[] stringArray = string.split("\\s*[=\\s]\\s*", 2);
        return stringArray;
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        Set set = this.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            properties.put(string, this.get(string));
        }
        return properties;
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = (String)this.properties.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public boolean containsKey(Object object) {
        return this.properties.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.properties.containsValue(object);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public int size() {
        return this.properties.size();
    }

    public String get(Object object) {
        Object v = this.properties.get(object);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public Collection values() {
        return this.properties.values();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WsadminPropertiesUtil [");
        if (this.getEncoding() != null) {
            stringBuffer.append("encoding=");
            stringBuffer.append(this.getEncoding());
            stringBuffer.append(", ");
        }
        if (this.propertyFileAbsPath != null) {
            stringBuffer.append("propertyFileAbsPath=");
            stringBuffer.append(this.propertyFileAbsPath);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = Globals.getPropertyFileEncoding();
        }
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    private BufferedReader newReader(FileInputStream fileInputStream, String string) throws UnsupportedEncodingException, FileNotFoundException {
        String string2 = "newReader";
        logger.entering(CLASS_NAME, string2, new Object[]{fileInputStream, string});
        InputStreamReader inputStreamReader = string != null ? new InputStreamReader((InputStream)fileInputStream, Charset.forName(string)) : new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINE, CLASS_NAME, string2, "CRWWA0007D", new Object[]{fileInputStream, inputStreamReader.getEncoding()});
        }
        logger.exiting(CLASS_NAME, string2, bufferedReader);
        return bufferedReader;
    }

    private void validateProperty(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string.matches("[\\s#]+.*")) {
            throw new IllegalArgumentException("Specified 'Key', or 'Value' argument is not valid.");
        }
    }

    private void removeLine(String string) {
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            String string2 = (String)this.lines.get(i);
            if (!string2.matches(string + "\\s*=.*")) continue;
            this.lines.remove(i);
            break;
        }
    }

    public String remove(Object object) {
        Object v;
        if (object != null) {
            this.removeLine(object.toString());
        }
        if ((v = this.properties.remove(object)) == null) {
            return null;
        }
        return v.toString();
    }

    public String setProperty(String string, String string2) {
        this.validateProperty(string, string2);
        if (this.properties.containsKey(string)) {
            this.updateLine(string, string2);
        } else {
            this.addLine(string, string2);
        }
        return this.properties.put(string, string2);
    }

    private void updateLine(String string, String string2) {
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            String string3 = (String)this.lines.get(i);
            if (!string3.matches(string + "\\s*=.*")) continue;
            string3 = string + "=" + string2;
            this.lines.set(i, string3);
            break;
        }
    }

    private void addLine(String string, String string2) {
        String string3 = string + "=" + string2;
        this.lines.add(string3);
    }

    public void addComment(String string) {
        if (!string.startsWith("#")) {
            string = "## " + string;
        }
        this.lines.add(string);
    }

    public void addComments(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            this.addComment(string);
        }
    }

    public void addComment(String string, int n) {
        if (!string.startsWith("#")) {
            string = "## " + string;
        }
        if (n > this.lines.size()) {
            this.lines.add(string);
        } else {
            this.lines.add(n, string);
        }
    }

    public void addBlankLine() {
        this.lines.add("");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

