/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.websphere.config;

import com.ibm.rational.rafw.wsadmin.websphere.config.WsadminConfig;
import com.ibm.rational.rafw.wsadmin.websphere.config.normalization.AdoptionAttributeVisitor;
import com.ibm.rational.rafw.wsadmin.websphere.config.normalization.AdoptionChildVisitor;
import com.ibm.rational.rafw.wsadmin.websphere.config.normalization.AdoptionVisitor;
import com.ibm.rational.rafw.wsadmin.websphere.config.normalization.INormalizationVisitor;
import com.ibm.rational.rafw.wsadmin.websphere.config.normalization.ParentKillerVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WsadminConfigUtils {
    private static final String DOT_SEPERATOR = ".";
    private static final String CONFIG_TYPE_PME51_SERVER_EXTENSION = "PME51ServerExtension";
    private static final String CONFIG_TYPE_PME_SERVER_EXTENSION = "PMEServerExtension";
    private static final String CONFIG_TYPE_CLASSLOADER = "Classloader";
    private static final String CONFIG_TYPE_APPLICATION_SERVER = "ApplicationServer";
    private static final String CONFIG_TYPE_STREAM_REDIRECT = "StreamRedirect";
    private static final String CONFIG_TYPE_SERVER = "Server";
    private static final String CONFIG_ATTR_ERROR_STREAM_REDIRECT = "errorStreamRedirect";
    private static final String CONFIG_ATTR_OUTPUT_STREAM_REDIRECT = "outputStreamRedirect";

    public static List normalize(WsadminConfig wsadminConfig) {
        ArrayList<WsadminConfig> arrayList = new ArrayList<WsadminConfig>();
        String string = "RAFW_" + wsadminConfig.getId();
        WsadminConfig wsadminConfig2 = new WsadminConfig();
        wsadminConfig2.setId(string);
        wsadminConfig2.addChild(wsadminConfig);
        arrayList.add(wsadminConfig2);
        List list = wsadminConfig.getChildren();
        wsadminConfig.setChildren(null);
        INormalizationVisitor[] iNormalizationVisitorArray = WsadminConfigUtils.createNormalizatonVisitors(wsadminConfig.getId());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WsadminConfig wsadminConfig3 = (WsadminConfig)iterator.next();
            for (int i = 0; i < iNormalizationVisitorArray.length && iNormalizationVisitorArray[i].visit(wsadminConfig3); ++i) {
            }
        }
        for (int i = 0; i < iNormalizationVisitorArray.length; ++i) {
            arrayList.addAll(iNormalizationVisitorArray[i].getResults());
        }
        return arrayList;
    }

    private static INormalizationVisitor[] createNormalizatonVisitors(String string) {
        if (CONFIG_TYPE_SERVER.equals(string)) {
            INormalizationVisitor[] iNormalizationVisitorArray = new INormalizationVisitor[]{new AdoptionAttributeVisitor(CONFIG_TYPE_STREAM_REDIRECT, new String[]{CONFIG_ATTR_OUTPUT_STREAM_REDIRECT, CONFIG_ATTR_ERROR_STREAM_REDIRECT}, CONFIG_TYPE_SERVER.toUpperCase() + DOT_SEPERATOR), new AdoptionChildVisitor(CONFIG_TYPE_APPLICATION_SERVER, CONFIG_TYPE_CLASSLOADER, DOT_SEPERATOR), new ParentKillerVisitor(new String[]{CONFIG_TYPE_PME_SERVER_EXTENSION, CONFIG_TYPE_PME51_SERVER_EXTENSION}), new AdoptionVisitor()};
            return iNormalizationVisitorArray;
        }
        INormalizationVisitor[] iNormalizationVisitorArray = new INormalizationVisitor[]{new AdoptionVisitor()};
        return iNormalizationVisitorArray;
    }
}

