/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.websphere.config.compare;

import com.ibm.rational.rafw.wsadmin.websphere.config.IWsadminConfig;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.KeyComparator;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.diff.DiffResult;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.diff.StringDiffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ConfigCompareTools {
    private static final char PASSWD_MASK_CHAR = '*';
    private Comparator comparator;
    private Comparator sorter;

    public ConfigCompareTools(Comparator comparator) {
        this.sorter = comparator;
        this.comparator = comparator;
    }

    public ConfigCompareTools(Comparator comparator, Comparator comparator2) {
        this.sorter = comparator;
        this.comparator = comparator2;
    }

    public ConfigCompareTools(String string) {
        this.sorter = this.comparator = new KeyComparator(string);
    }

    public ConfigCompareTools(List list) {
        this.sorter = this.comparator = new KeyComparator(list);
    }

    public List findComplementInA(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList(list2);
        Collections.sort(arrayList2, this.sorter);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = Collections.binarySearch(arrayList2, e, this.sorter);
            if (n < 0) {
                arrayList.add(e);
                continue;
            }
            Object e2 = arrayList2.remove(n);
            if (this.comparator.compare(e, e2) == 0) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public List findIntersection(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList(list2);
        Collections.sort(arrayList2, this.sorter);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e;
            Object e2 = iterator.next();
            int n = Collections.binarySearch(arrayList2, e2, this.sorter);
            if (n < 0 || this.comparator.compare(e2, e = arrayList2.remove(n)) != 0) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public final List findRecursiveIntersection(List list, List list2) {
        ArrayList<IWsadminConfig> arrayList = new ArrayList<IWsadminConfig>();
        Collections.sort(list2, this.sorter);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IWsadminConfig iWsadminConfig = (IWsadminConfig)iterator.next();
            int n = Collections.binarySearch(list2, iWsadminConfig, this.sorter);
            if (n < 0 || !this.isAFullMatch(iWsadminConfig, (IWsadminConfig)list2.get(n))) continue;
            arrayList.add(iWsadminConfig);
        }
        return arrayList;
    }

    public final boolean isAFullMatch(IWsadminConfig iWsadminConfig, IWsadminConfig iWsadminConfig2) {
        int n = this.comparator.compare(iWsadminConfig, iWsadminConfig2);
        if (n == 0) {
            List list = iWsadminConfig.getChildren();
            List list2 = iWsadminConfig2.getChildren();
            if (list.size() == 0 && list2.size() == 0) {
                return true;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            boolean bl = true;
            Collections.sort(list2, this.sorter);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IWsadminConfig iWsadminConfig3 = (IWsadminConfig)iterator.next();
                int n2 = Collections.binarySearch(list2, iWsadminConfig3, this.sorter);
                if (n2 >= 0) {
                    bl &= this.isAFullMatch(iWsadminConfig3, (IWsadminConfig)list2.get(n2));
                    continue;
                }
                return false;
            }
            return bl;
        }
        return false;
    }

    public static DiffResult compareByKey(IWsadminConfig iWsadminConfig, IWsadminConfig iWsadminConfig2, String string) {
        String string2 = (String)iWsadminConfig.getAttributes().get(string);
        String string3 = (String)iWsadminConfig2.getAttributes().get(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string2 == null && string3 == null) {
            return new DiffResult(0);
        }
        if (string2 == null && string3 != null) {
            if ("WASKey".equals(string)) {
                return new DiffResult(0);
            }
            return new DiffResult(-1);
        }
        if (string2 != null && string3 == null) {
            if ("WASKey".equals(string)) {
                return new DiffResult(0);
            }
            return new DiffResult(1);
        }
        return StringDiffer.compareTo(string2, string3);
    }

    public static String obfuscateString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char[] cArray = new char[string.length()];
        Arrays.fill(cArray, 0, string.length(), '*');
        return new String(cArray);
    }
}

