/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.performance;

import com.ibm.rational.rafw.wsadmin.performance.Performance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PerfData {
    private ArrayList times;
    private String name;
    private long startTime = 0L;
    private HashSet childTasks;
    private PerfData parent;
    private HashMap timesByParent;
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$performance$PerfData == null ? (class$com$ibm$rational$rafw$wsadmin$performance$PerfData = PerfData.class$("com.ibm.rational.rafw.wsadmin.performance.PerfData")) : class$com$ibm$rational$rafw$wsadmin$performance$PerfData).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$performance$PerfData;

    public PerfData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument 'name' cannot be null");
        }
        this.name = string;
        this.times = new ArrayList();
        this.timesByParent = new HashMap();
        this.childTasks = new HashSet();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void start(PerfData perfData) {
        this.startTime = System.currentTimeMillis();
        this.parent = perfData;
    }

    public void end() {
        if (this.startTime == 0L) {
            logger.log(Level.FINE, "Ignoring performance end time for '" + this.name + "': 'end' called without calling 'start'");
        } else {
            long l = System.currentTimeMillis();
            this.addTime(this.parent, l - this.startTime);
            this.parent = null;
        }
    }

    private void addTime(PerfData perfData, long l) {
        if (perfData != null) {
            if (!this.timesByParent.containsKey(perfData)) {
                this.timesByParent.put(perfData, new ArrayList());
            }
            ((ArrayList)this.timesByParent.get(perfData)).add(new Long(l));
        }
        this.times.add(new Long(l));
    }

    public long getLowest() {
        if (this.times.size() > 0) {
            Long l = (Long)Collections.min(this.times);
            return l;
        }
        return -1L;
    }

    public long getHighest() {
        if (this.times.size() > 0) {
            Long l = (Long)Collections.max(this.times);
            return l;
        }
        return -1L;
    }

    public int getCount() {
        return this.times.size();
    }

    public String getOrderedTimes() {
        String[] stringArray = new String[this.times.size()];
        int n = 0;
        Iterator iterator = this.times.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next().toString();
        }
        return Performance.joinStrings(stringArray, ", ");
    }

    public int getChildTaskCount() {
        return this.childTasks.size();
    }

    public String getChildTaskNames() {
        String[] stringArray = new String[this.childTasks.size()];
        int n = 0;
        Iterator iterator = this.childTasks.iterator();
        while (iterator.hasNext()) {
            PerfData perfData = (PerfData)iterator.next();
            stringArray[n++] = perfData.getDisplayName();
        }
        return Performance.joinStrings(stringArray, ", ");
    }

    public double getAverage() {
        long l = this.getTotalTime();
        if (this.times.size() > 0) {
            return l / (long)this.times.size();
        }
        return -1.0;
    }

    public double getAverageLessChildTask() {
        long l = this.getTotalTime() - this.getChildTaskTotalTime();
        if (this.times.size() > 0) {
            return l / (long)this.times.size();
        }
        return -1.0;
    }

    public long getTotalTime() {
        long l = 0L;
        Iterator iterator = this.times.iterator();
        while (iterator.hasNext()) {
            Long l2 = (Long)iterator.next();
            l += l2.longValue();
        }
        return l;
    }

    public long getTotalTime(PerfData perfData) {
        if (perfData == null || !this.timesByParent.containsKey(perfData)) {
            return this.getTotalTime();
        }
        long l = 0L;
        ArrayList arrayList = (ArrayList)this.timesByParent.get(perfData);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Long l2 = (Long)iterator.next();
            l += l2.longValue();
        }
        return l;
    }

    public long getChildTaskTotalTime() {
        long l = 0L;
        Iterator iterator = this.childTasks.iterator();
        while (iterator.hasNext()) {
            PerfData perfData = (PerfData)iterator.next();
            l += perfData.getTotalTime(this);
        }
        return l;
    }

    public String getDisplayName() {
        if (this.name.length() > 100) {
            StringBuffer stringBuffer = new StringBuffer(105);
            stringBuffer.append(this.name.substring(0, 50));
            stringBuffer.append("...");
            stringBuffer.append(this.name.substring(this.name.length() - 50));
            return stringBuffer.toString();
        }
        return this.name;
    }

    public void addChildTask(PerfData perfData) {
        if (!this.equals(perfData)) {
            this.childTasks.add(perfData);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PerfData perfData = (PerfData)object;
        return !(this.name == null ? perfData.name != null : !this.name.equals(perfData.name));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

