/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.websphere;

public class WebSphereFileFindHelper {

    def isWindows;
    String file;

    public WebSphereFileFindHelper(def isWindows, String file) {
        this.isWindows = isWindows;
        this.file = file;
    }

    public checkFileInPath() throws FileNotFoundException{
        def filePath = [];
        def foundPath = "";

        if (isWindows) {
            filePath << "C:" + File.separator + "Program Files" + File.separator + "IBM" + File.separator + "WebSphere" + File.separator + "AppServer" + File.separator + "bin" + File.separator + file;
            filePath << "C:" + File.separator + "IBM" + File.separator + "WebSphere" + File.separator + "AppServer" + File.separator + "bin" + File.separator + file;
        }
        else {
            filePath << "/opt/IBM/WebSphere/AppServer/bin/"+file;
        }

        for (path in filePath) {
            File f = new File(path);
            println "Checking path for the specified file in the given path: " + path;
            if (f.exists()) {
                foundPath = f.getAbsolutePath();
                println "Found the script file:"+foundPath;
                return foundPath;
            }
        }

        if(!foundPath) {
            throw new FileNotFoundException("Script file not found");
        }
    }
}