/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

clusterName = props['clusterName'];
jdbcProviderName = props['jdbcproviderName'];
if (clusterName?.trim()) {
    scope="/ServerCluster:"+clusterName+"/JDBCProvider:"+jdbcProviderName+"/";
}
else {
    scope=props['jdbcProviderLocation'];
}

name=props['name'];
jndiName=props['jndiName'];
dataStoreClassName= props['dataStoreClassName'];
description=props['desc'];
resourceProperties=props['resourceProperties'].replaceAll("\n", "\\\\n");
username=props['aliasUsername'];
password=props['aliasPassword'];
authAlias=props['authAlias'];

StringBuilder builder = new StringBuilder();
builder.append("createDataSource(")
           .append("\"").append(scope).append("\"").append(",")
           .append("\"").append(name).append("\"").append(",")
           .append("\"").append(jndiName).append("\"").append(",")
           .append("\"").append(dataStoreClassName).append("\"").append(",")
           .append("\"").append(description).append("\"").append(",")
           .append("\"").append(resourceProperties).append("\"").append(",")
           .append("\"").append(username).append("\"").append(",")
           .append("\"").append(password).append("\"").append(",")
           .append("\"").append(authAlias).append("\"")
builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
