/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

blaName=props['blaName'];
assetName=props['assetName'];
compUnitName=props['compUnitName'];
description=props['description'];
startingWeight=props['startingWeight'];
restartBehaviour=props['restartBehaviour'];
virtualHostsMappings = props['virtualHostMappings'].replaceAll("\n", "\\\\n");
contextRootMappings = props['contextRootMappings'].replaceAll("\n", "\\\\n");;

StringBuilder builder = new StringBuilder();
builder.append("addAssetToBLA(")
           .append("\"").append(blaName).append("\"").append(",")
           .append("\"").append(assetName).append("\"").append(",")
           .append("\"").append(compUnitName).append("\"").append(",")
           .append("\"").append(description).append("\"").append(",")
           .append("\"").append(startingWeight).append("\"").append(",")
           .append("\"").append(restartBehaviour).append("\"").append(",")
           .append("\"").append(virtualHostsMappings).append("\"").append(",")
           .append("\"").append(contextRootMappings).append("\"")
builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
