/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def PLUGIN_HOME= System.getenv("PLUGIN_HOME");
def cell = props['cell']
def node = props['node']
def server = props['server']
def cluster = props['cluster']
def moduleURI = props['moduleURI']
def appName = props['appName']
def appEdition = props['appEdition']
def command; 
if (server == null || server.startsWith('${p:') || server.trim() == "") {
    //clustercommand
    StringBuilder builder = new StringBuilder();
    builder.append("mapClusterToModule(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(moduleURI).append("\"").append(",")
               .append("\"").append(cell).append("\"").append(",")
               .append("\"").append(cluster).append("\"")
           .append(")")
    command = builder.toString();
}
else {
    //servercommand
    StringBuilder builder = new StringBuilder();
    builder.append("mapServerToModule(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(moduleURI).append("\"").append(",")
               .append("\"").append(cell).append("\"").append(",")
               .append("\"").append(node).append("\"").append(",")
               .append("\"").append(server).append("\"")
           .append(")")
    command = builder.toString();
}

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
