/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def action = this.args[2];
def props = apTool.getStepProperties();
def propertiesFileName = props['propertiesFileName']
def variablesMapFileName = props['variablesMapFileName']
def variablesMap = props['variablesMap'].replace("\n","\\n")
def reportFileName = props['reportFileName']
def reportFilterMechanism = props['reportFilterMechanism']
def validate = props['validate']
def zipFileName = props['zipFileName']

StringBuilder builder = new StringBuilder();
builder.append("adminConfigProperties(")
           .append("\"").append(action).append("\"").append(",")
           .append("\"").append(propertiesFileName).append("\"").append(",")
           .append("\"").append(variablesMapFileName?:"").append("\"").append(",")
           .append("\"").append(variablesMap?:"").append("\"").append(",")
           .append("\"").append(reportFileName?:"").append("\"").append(",")
           .append("\"").append(reportFilterMechanism?:"").append("\"").append(",")
           .append("\"").append(validate?:"").append("\"").append(",")
           .append("\"").append(zipFileName?:"").append("\"")
       .append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
