/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

cell = props['cell'];
cluster = props['cluster'];
node = props['node'];
server = props['server'];
name=props['name'];
classpath=props['classpath'].replaceAll("\n", "\\\\n");
nativepath= props['nativepath'].replaceAll("\n", "\\\\n");
description=props['description'].replaceAll("\n", "\\\\n");

StringBuilder builder = new StringBuilder();
builder.append("createSharedLibrary(")
           .append("\"").append(cell).append("\"").append(",")
           .append("\"").append(cluster).append("\"").append(",")
           .append("\"").append(node).append("\"").append(",")
           .append("\"").append(server).append("\"").append(",")
           .append("\"").append(name).append("\"").append(",")
           .append("\"").append(classpath).append("\"").append(",")
           .append("\"").append(nativepath).append("\"").append(",")
           .append("\"").append(description).append("\"")
builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
