/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def PLUGIN_HOME= System.getenv("PLUGIN_HOME");
def name = props['name'];
def version = props['version']?.trim();
def force = props['force']
def pluginHome = new File(PLUGIN_HOME);
def scriptsDir = new File(pluginHome, "jythonScripts")
def scriptFile = new File(scriptsDir, "deleteAsset.jython");
def scriptPath = scriptFile.absolutePath; 
WebSphereCmdLineHelper helper = new WebSphereCmdLineHelper(props);
def args = [];
args << name;
args << force;
if (version != null && version != "") {
    args << version;
}
helper.runWSAdminScript(scriptPath, "Deleting Asset", args as String[]);
