/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def cell = props['cell']
def server = props['server']
def commandPath = (props['commandPath']!=null?props['commandPath']:"");
def node = props['node']
def user = props['user']
def password = (props['password'] != null && props['password'] != "")? props['password'] : props['passScript']
def cluster = props['cluster']
def appName = props['appName']
def connType = props['connType']
def host = props['host'];
def port = props['port'];
def isSyncAllNodes = props['isSyncAllNodes']
def isFullSync = props['isFullSync']
def additionalArgs = props['additionalArgs']
def deleteTempFileOnFailure = Boolean.valueOf(props['deleteTempFileOnFailure'])

StringBuilder builder = new StringBuilder();
builder.append("syncNodes(")
           .append("\"").append(node).append("\"").append(",")
           .append("\"").append(isSyncAllNodes).append("\"").append(",")
           .append("\"").append(isFullSync).append("\"")
       .append(")")
command = builder.toString()

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props)
helper.execute(command)
