/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.websphere.config.compare;

import com.ibm.rational.rafw.wsadmin.logging.MessageManager;
import com.ibm.rational.rafw.wsadmin.websphere.config.IWsadminConfig;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.CompareDisplayProperties;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.ConfigCompareTools;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.WsadminMetaData;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.diff.DiffResult;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.result.CompareResult;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.result.DifferentAttributesResult;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.result.ICompareResult;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.result.ICompareResultContainer;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.result.OnlyLocalResult;
import com.ibm.rational.rafw.wsadmin.websphere.config.compare.result.OnlyRemoteResult;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompareDisplay {
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$websphere$config$compare$CompareDisplay == null ? (class$com$ibm$rational$rafw$wsadmin$websphere$config$compare$CompareDisplay = CompareDisplay.class$("com.ibm.rational.rafw.wsadmin.websphere.config.compare.CompareDisplay")) : class$com$ibm$rational$rafw$wsadmin$websphere$config$compare$CompareDisplay).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    private static final String CONFIDENTIAL_FLAG = "password";
    private static final String LINE_DISP = "-------------------------";
    private final MessageFormat keyFmt;
    private final MessageFormat keyDisplayFmt;
    private final MessageFormat onlyRemoteFmt;
    private final MessageFormat onlyLocalFmt;
    private final MessageFormat attrDisplayFmt;
    private final MessageFormat diffAttrDisplayFmt;
    private final int diffMarkerLength = 3;
    private WsadminMetaData metaData;
    private CompareDisplayProperties displayProps;
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$websphere$config$compare$CompareDisplay;

    public CompareDisplay() {
        this(new CompareDisplayProperties());
    }

    public CompareDisplay(CompareDisplayProperties compareDisplayProperties) {
        this.displayProps = compareDisplayProperties;
        this.metaData = WsadminMetaData.getInstance();
        this.keyFmt = new MessageFormat("{0} = \"{1}\" ");
        this.keyDisplayFmt = new MessageFormat("{0}< {1} {2} > \n");
        this.onlyRemoteFmt = new MessageFormat("{3} {0}< {1} {2} >\n");
        this.onlyLocalFmt = new MessageFormat("{3}  {0}< {1} {2} >\n");
        this.attrDisplayFmt = new MessageFormat("{0} {1} {2} {3} \n");
        this.diffAttrDisplayFmt = new MessageFormat("{0}[X] {1} {2} {3} \n");
    }

    public void displayComparison(CompareResult compareResult, Writer writer) {
        try {
            if (compareResult.differencesFound()) {
                String string = this.displayProps.getSummaryMessage();
                writer.write(string);
                writer.write("\n");
                this.displayComparisonRecursive(compareResult, 0, writer);
            } else {
                String string = MessageManager.getExceptionMessage("com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages", "CRWWA1504I", compareResult.getParent().getId());
                writer.write(string);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Unable to write messages to the Writer: " + iOException.getLocalizedMessage(), iOException);
        }
    }

    private void displayComparisonRecursive(ICompareResultContainer iCompareResultContainer, int n, Writer writer) throws IOException {
        Iterator iterator = iCompareResultContainer.getChildren().iterator();
        while (iterator.hasNext()) {
            ICompareResult iCompareResult = (ICompareResult)iterator.next();
            if (iCompareResult instanceof OnlyLocalResult) {
                this.displayObjectWithKey(((OnlyLocalResult)iCompareResult).getResult(), writer, n, this.onlyLocalFmt, this.displayProps.getOnlyFirst());
                this.displayAttributes2Col(((OnlyLocalResult)iCompareResult).getResult(), writer, n, this.displayProps.getFirstColDisplay());
                continue;
            }
            if (iCompareResult instanceof OnlyRemoteResult) {
                this.displayObjectWithKey(((OnlyRemoteResult)iCompareResult).getResult(), writer, n, this.onlyRemoteFmt, this.displayProps.getOnlySecond());
                this.displayAttributes2Col(((OnlyRemoteResult)iCompareResult).getResult(), writer, n, this.displayProps.getSecondColDisplay());
                continue;
            }
            if (iCompareResult instanceof ICompareResultContainer) {
                this.displayObjectWithKey(((ICompareResultContainer)iCompareResult).getParent(), writer, n, this.keyDisplayFmt, "");
                if (iCompareResult instanceof DifferentAttributesResult) {
                    this.displayAllAttributes(((DifferentAttributesResult)iCompareResult).getLocal(), ((DifferentAttributesResult)iCompareResult).getRemote(), writer, n);
                }
                this.displayComparisonRecursive((ICompareResultContainer)iCompareResult, n + 1, writer);
                continue;
            }
            logger.log(Level.FINE, "An invalid class was provided to the comparison results display tool: " + iCompareResult.getClass());
        }
    }

    private void displayObjectWithKey(IWsadminConfig iWsadminConfig, Writer writer, int n, MessageFormat messageFormat, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.metaData.getKeys(iWsadminConfig.getId()).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Map map = iWsadminConfig.getAttributes();
            if (!map.containsKey(string2)) continue;
            String string3 = (String)map.get(string2);
            if (string2.toLowerCase().indexOf(CONFIDENTIAL_FLAG) != -1) {
                string3 = ConfigCompareTools.obfuscateString(string3);
            }
            stringBuffer.append(this.keyFmt.format(new Object[]{string2, string3}));
        }
        writer.write(messageFormat.format(new Object[]{this.getPadding(n), iWsadminConfig.getId(), stringBuffer.toString(), string}));
    }

    private void displayAllAttributes(IWsadminConfig iWsadminConfig, IWsadminConfig iWsadminConfig2, Writer writer, int n) throws IOException {
        List list = this.metaData.getKeys(iWsadminConfig.getId());
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(iWsadminConfig.getAttributes().keySet());
        treeSet.addAll(iWsadminConfig2.getAttributes().keySet());
        treeSet.removeAll(list);
        treeSet.remove("RAFW_TYPE");
        treeSet.remove("WASKey");
        if (treeSet.size() > 0) {
            String string = this.getPadding(n);
            writer.write(this.attrDisplayFmt.format(new Object[]{string, this.fill(LINE_DISP, this.displayProps.getAttrNameColWidth()), this.fill(LINE_DISP, this.displayProps.getAttrValueColWidth()), this.fill(LINE_DISP, this.displayProps.getAttrValueColWidth())}));
            writer.write(this.attrDisplayFmt.format(new Object[]{string, this.fill(this.displayProps.getAttrDisp(), this.displayProps.getAttrNameColWidth()), this.fill(this.displayProps.getFirstColDisplay(), this.displayProps.getAttrValueColWidth()), this.fill(this.displayProps.getSecondColDisplay(), this.displayProps.getAttrValueColWidth())}));
            writer.write(this.attrDisplayFmt.format(new Object[]{string, this.fill(LINE_DISP, this.displayProps.getAttrNameColWidth()), this.fill(LINE_DISP, this.displayProps.getAttrValueColWidth()), this.fill(LINE_DISP, this.displayProps.getAttrValueColWidth())}));
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)iWsadminConfig.getAttributes().get(string2);
                String string4 = (String)iWsadminConfig2.getAttributes().get(string2);
                if (string2.toLowerCase().indexOf(CONFIDENTIAL_FLAG) != -1) {
                    string3 = ConfigCompareTools.obfuscateString(string3);
                    string4 = ConfigCompareTools.obfuscateString(string4);
                }
                DiffResult diffResult = ConfigCompareTools.compareByKey(iWsadminConfig, iWsadminConfig2, string2);
                int n2 = diffResult.getIndex();
                String string5 = this.fill(string3, this.displayProps.getAttrValueColWidth(), n2);
                String string6 = this.fill(string4, this.displayProps.getAttrValueColWidth(), n2);
                if (diffResult.getCode() != 0) {
                    String string7 = string.length() > 3 ? string.substring(3) : string;
                    writer.write(this.diffAttrDisplayFmt.format(new Object[]{string7, this.fill(string2, this.displayProps.getAttrNameColWidth()), string5, string6}));
                    continue;
                }
                writer.write(this.attrDisplayFmt.format(new Object[]{string, this.fill(string2, this.displayProps.getAttrNameColWidth()), string5, string6}));
            }
        }
    }

    private void displayAttributes2Col(IWsadminConfig iWsadminConfig, Writer writer, int n, String string) throws IOException {
        List list = this.metaData.getKeys(iWsadminConfig.getId());
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(iWsadminConfig.getAttributes().keySet());
        treeSet.removeAll(list);
        treeSet.remove("RAFW_TYPE");
        treeSet.remove("WASKey");
        if (treeSet.size() > 0) {
            String string2 = this.getPadding(n);
            writer.write(this.attrDisplayFmt.format(new Object[]{string2, this.fill(LINE_DISP, this.displayProps.getAttrNameColWidth()), this.fill(LINE_DISP, this.displayProps.getAttrValueColWidth()), ""}));
            writer.write(this.attrDisplayFmt.format(new Object[]{string2, this.fill(this.displayProps.getAttrDisp(), this.displayProps.getAttrNameColWidth()), this.fill(string, this.displayProps.getAttrValueColWidth()), ""}));
            writer.write(this.attrDisplayFmt.format(new Object[]{string2, this.fill(LINE_DISP, this.displayProps.getAttrNameColWidth()), this.fill(LINE_DISP, this.displayProps.getAttrValueColWidth()), ""}));
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)iWsadminConfig.getAttributes().get(string3);
                if (string3.toLowerCase().indexOf(CONFIDENTIAL_FLAG) != -1) {
                    string4 = ConfigCompareTools.obfuscateString(string4);
                }
                writer.write(this.attrDisplayFmt.format(new Object[]{string2, this.fill(string3, this.displayProps.getAttrNameColWidth()), this.fill(string4, this.displayProps.getAttrValueColWidth()), ""}));
            }
        }
    }

    private String getPadding(int n) {
        char[] cArray = new char[n * 5];
        Arrays.fill(cArray, 0, n * 5, ' ');
        return new String(cArray);
    }

    private String fill(String string, int n) {
        return this.fill(string, n, 0);
    }

    private String fill(String string, int n, int n2) {
        if (string == null) {
            string = "null";
        }
        char[] cArray = new char[n];
        if (string.length() <= n) {
            string.getChars(0, string.length(), cArray, 0);
            if (string.length() < n) {
                Arrays.fill(cArray, string.length(), n, ' ');
            }
        } else {
            int n3;
            int n4 = n / 2;
            int n5 = n2 - n4;
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n3 = n2 + n4) > string.length()) {
                n3 = string.length() - 1;
            }
            string.getChars(n5, n3, cArray, 0);
        }
        return new String(cArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

