/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.io.*;
import java.util.*;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
out = System.out;
def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def appName = props['appName']
def appEdition = props['appEdition']
def groupSize = props['groupSize']
def resetStrategy = props['resetStrategy']
def drainageInterval = props['drainageInterval']
def quiesceInterval = props['quiesceInterval']


StringBuilder builder = new StringBuilder();
builder.append("groupRolloutEdition(")
           .append("\"").append(appName).append("\"").append(",")
           .append("\"").append(appEdition?:"").append("\"").append(",")
           .append("\"").append(groupSize).append("\"").append(",")
           .append("\"").append(resetStrategy).append("\"").append(",")
           .append("\"").append(drainageInterval).append("\"");
           if (quiesceInterval != null && quiesceInterval.trim() != "") {
               builder.append(",").append("\"").append(quiesceInterval).append("\"")
           }
       builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
