/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper;

final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
out = System.out;

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def cell = props['cell']
def server = props['server']
def commandPath = (props['commandPath']!=null?props['commandPath']:"");
def node = props['node']
def user = props['user']
def password = (props['password'] != null && props['password'] != "")? props['password'] : props['passScript']
def cluster = props['cluster']

def connType = props['connType']
def host = props['host'];
def port = props['port'];
def additionalArgs = props['additionalArgs'];
def deleteTempFileOnFailure = Boolean.valueOf(props['deleteTempFileOnFailure'])


File tempFile = File.createTempFile("temp", ".py", new File("."))
if (deleteTempFileOnFailure) {
    tempFile.deleteOnExit();
}
BufferedWriter temp = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile), "UTF-8"))
def cellarg = cell ? " -cell " + cell : "";

if (server != null && server.trim() != "" && !server.startsWith('${p:')) {
    invoke = "object = AdminControl.queryNames('type=Server,process=" + server+",*')\n";
}
else {
    invoke = "object = AdminControl.queryNames('type=Cluster,name="+cluster+",*');\n"
}
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);

invoke = "if object == None or object.strip() == '':\n";
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);
invoke = "\tprint 'Object not found... either it does not exist or is not running'\n";
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);
invoke = "\tsys.exit(1);\n";
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);
invoke = "\nstatus = AdminControl.invoke(object, 'getState').strip().lower();\n"
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);
invoke = "if status.find('running') == -1 and status.find('started') == -1:\n"
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);
invoke = "\tprint 'Status not in running state: ' + status;\n";
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);
invoke = "\tsys.exit(1);\n\nprint 'Object in running state';\nsys.exit(0);"
temp.write(invoke, 0, invoke.length());
System.out.println(invoke);

temp.close();

def commandArgs = [commandPath + WebSphereCmdLineHelper.getWSADMINValue(), "-lang", "jython"];

commandArgs << "-conntype"
commandArgs << connType.trim();

if (host) {
    commandArgs << "-host";
    commandArgs << host;
}

if (port) {
    commandArgs << "-port";
    commandArgs << port;
}

if (user) {
    commandArgs << "-user"
    commandArgs <<  user
    commandArgs << "-password"
    commandArgs << password
}

commandArgs << "-f";
commandArgs << tempFile.getName();

if (additionalArgs) {
    additionalArgs.split('\n').each { arg ->
        commandArgs << arg;
    }
}

println commandArgs.join(' ');
def procBuilder = new ProcessBuilder(commandArgs);

if (isWindows) {
    def envMap = procBuilder.environment();
    envMap.put("PROFILE_CONFIG_ACTION","true");
}

def statusProc = procBuilder.start();
def outPrint = new PrintStream(out, true);
statusProc.waitForProcessOutput(outPrint, outPrint);
def exitVal = statusProc.exitValue();
if (exitVal == 0) {
    tempFile.delete();
}
System.exit(exitVal);
