/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.io.*;
import java.util.*;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper


final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
out = System.out;
def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def cell = props['cell']
def server = props['server']
def node = props['node']
def cluster = props['cluster']

def appName = props['appName'].trim();
def appEdition = props['appEdition']
def editDesc = props['editDesc']
def context = props['context']
def location = props['location']
def path = props['path']
def argString = props['argString']
def partialUpdate = props['partialUpdate']


if (server == null || server.startsWith('${p:') || server.trim() == "") {
    //cluster
    StringBuilder builder = new StringBuilder();
    builder.append("installOrUpdateApplicationInCluster(")
               .append("\"").append(location).append("\"").append(",")
               .append("\"").append(cluster).append("\"").append(",")
               .append("\"").append(context?:"").append("\"").append(",")
               .append("\"").append(path?:"").append("\"").append(",")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(editDesc?:"").append("\"").append(",")
               .append("\"").append(partialUpdate?:"false").append("\"").append(",")
               .append("\'").append(argString?:"").append("\'")
           .append(")")
    command = builder.toString();
}
else {
     //server
    StringBuilder builder = new StringBuilder();
    builder.append("installOrUpdateApplicationInServer(")
               .append("\"").append(location).append("\"").append(",")
               .append("\"").append(server).append("\"").append(",")
               .append("\"").append(node).append("\"").append(",")
               .append("\"").append(context?:"").append("\"").append(",")
               .append("\"").append(path?:"").append("\"").append(",")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(editDesc?:"").append("\"").append(",")
               .append("\"").append(partialUpdate?:"false").append("\"").append(",")
               .append("\'").append(argString?:"").append("\'")
           .append(")")
    command = builder.toString();
}

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
