/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
out = System.out;
def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def cell = props['cell']
def server = props['server']
def node = props['node']
def cluster = props['cluster']
def appName = props['appName']
def appType = props['appType']
def appEdition = props['appEdition']
File f = File.createTempFile("temp",".py")
props.setProperty("scriptFile", f.getName())
f.delete()


if (server == null || server.startsWith('${p:') || server.trim() == "") {
    StringBuilder builder = new StringBuilder();
    builder.append("assertApplicationIsInstalledWithEdition(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"")
           .append(")")
    .append("\n    ")
           .append("assertApplicationIsNotRunningOnCluster(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(appType).append("\"").append(",")
               .append("\"").append(cluster).append("\"")
           .append(")")
    command = builder.toString();
}
else {
    StringBuilder builder = new StringBuilder();
    builder.append("assertApplicationIsInstalledWithEdition(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"")
           .append(")")
    .append("\n    ")
           .append("assertApplicationIsNotRunningOnServer(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\"").append(appType).append("\"").append(",")
               .append("\"").append(server).append("\"").append(",")
               .append("\"").append(node).append("\"")
           .append(")")
    command = builder.toString();
}

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
