/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.io.*;
import java.util.*;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
out = System.out

final def workDir = new File('.').canonicalFile
final def props = new Properties()
final def inputPropsFile = new File(args[0])
final def inputPropsStream = null
try {
    inputPropsStream = new FileInputStream(inputPropsFile)
    props.load(inputPropsStream)
}
catch (IOException e) {
    throw new RuntimeException(e)
}

def cell = props['cell']
def server = props['server']
def commandPath = (props['commandPath']!=null?props['commandPath']:"");
def node = props['node']
def user = props['user']
def password = (props['password'] != null && props['password'] != "")? props['password'] : props['passScript']
def cluster = props['cluster']
def appName = props['appName']
def connType = props['connType']
def host = props['host'];
def port = props['port'];
def isSyncAllNodes = props['isSyncAllNodes']
def isFullSync = props['isFullSync']
def additionalArgs = props['additionalArgs']
def deleteTempFileOnFailure = Boolean.valueOf(props['deleteTempFileOnFailure'])

StringBuilder builder = new StringBuilder();
builder.append("syncNodes(")
           .append("\"").append(node).append("\"").append(",")
           .append("\"").append(isSyncAllNodes).append("\"").append(",")
           .append("\"").append(isFullSync).append("\"")
       .append(")")
command = builder.toString()

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props)
helper.execute(command)