/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.io.*;
import java.util.*;
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
out = System.out;
def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def appName = props['appName'];
def appEdition = props['appEdition']
def sharedLibNames = props['sharedLibName'].split("\n");

def batch = props['batch'];
props['batch'] = true;
for (int i = 0; i < sharedLibNames.length; i++) {
    String sharedLibName = sharedLibNames[i].trim();
    StringBuilder builder = new StringBuilder();
    builder.append("addSharedLibraryToApplication(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\'").append(sharedLibName).append("\'")
           .append(")")
    command = builder.toString();
    
    if (i == sharedLibNames.length -1) {
        props['batch'] = batch;
    }
    WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
    helper.execute(command);
}

