/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.logging;

import com.ibm.rational.rafw.wsadmin.logging.FrameworkDateFormatter;
import com.ibm.rational.rafw.wsadmin.logging.LogUtil;
import com.ibm.rational.rafw.wsadmin.logging.MessageManager;
import com.ibm.rational.rafw.wsadmin.util.Globals;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class TraceFormatter
extends SimpleFormatter {
    public synchronized String format(LogRecord logRecord) {
        String string = logRecord.getMessage();
        if (string.startsWith("ENTRY") || string.startsWith("RETURN") || string.startsWith("THROW") || !string.startsWith("CRW")) {
            if (logRecord.getLevel() == Level.FINER) {
                if (string.startsWith("ENTRY") || string.startsWith("RETURN")) {
                    return this.generateEntryExitMessage(logRecord, string);
                }
                if (string.startsWith("THROW")) {
                    return this.generateThowMessage(logRecord);
                }
            }
            StringBuffer stringBuffer = this.getMessagePrefix(logRecord, "CRWWA9998D");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            if (logRecord.getThrown() != null) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    logRecord.getThrown().printStackTrace(printWriter);
                    printWriter.close();
                    stringBuffer.append(stringWriter.toString());
                }
                catch (Exception exception) {
                    stringBuffer.append(exception.getLocalizedMessage());
                }
            }
            return stringBuffer.toString();
        }
        char c = string.charAt(LogUtil.SEVERITY_CHAR_INDEX);
        if (!LogUtil.checkApplicableLevel(c, logRecord.getLoggerName())) {
            return "";
        }
        if (string.length() != LogUtil.KEY_LENGTH) {
            string = string.substring(0, LogUtil.KEY_LENGTH);
        }
        StringBuffer stringBuffer = this.getMessagePrefix(logRecord, string);
        stringBuffer.append(this.formatMessage(logRecord));
        stringBuffer.append("\n");
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            this.generateStackTrace(logRecord, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String generateThowMessage(LogRecord logRecord) {
        StringBuffer stringBuffer = this.getMessagePrefix(logRecord, "CRWWA9997D");
        stringBuffer.append(logRecord.getSourceClassName());
        stringBuffer.append(" ");
        stringBuffer.append(logRecord.getSourceMethodName());
        stringBuffer.append(" ");
        this.generateStackTrace(logRecord, stringBuffer);
        return stringBuffer.toString();
    }

    private void generateStackTrace(LogRecord logRecord, StringBuffer stringBuffer) {
        Throwable throwable = logRecord.getThrown();
        if (throwable == null) {
            stringBuffer.append("[No Throwable Exception in log record]");
        } else {
            int n;
            stringBuffer.append("[message=");
            stringBuffer.append(throwable.getLocalizedMessage());
            stringBuffer.append("]");
            stringBuffer.append("\n");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (n = 0; n < stackTraceElementArray.length && n < 10; ++n) {
                stringBuffer.append("    ");
                stringBuffer.append(stackTraceElementArray[n].toString());
                stringBuffer.append("\n");
            }
            n = stackTraceElementArray.length - 10 - 2;
            if (n > 0) {
                stringBuffer.append("    ");
                stringBuffer.append(MessageFormat.format(MessageManager.getMessage("com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages", "CRWWA9996I"), new Integer(n)));
                stringBuffer.append("\n");
                for (int i = stackTraceElementArray.length - 2 - 1; i < stackTraceElementArray.length; ++i) {
                    stringBuffer.append("    ");
                    stringBuffer.append(stackTraceElementArray[i]);
                    stringBuffer.append("\n");
                }
            }
        }
        stringBuffer.append("\n");
    }

    private String generateEntryExitMessage(LogRecord logRecord, String string) {
        StringBuffer stringBuffer = this.getMessagePrefix(logRecord, "CRWWA9998D");
        stringBuffer.append(logRecord.getSourceClassName());
        stringBuffer.append(" ");
        stringBuffer.append(logRecord.getSourceMethodName());
        stringBuffer.append(" ");
        stringBuffer.append(MessageFormat.format(string, logRecord.getParameters()));
        stringBuffer.append(" ");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private StringBuffer getMessagePrefix(LogRecord logRecord, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(FrameworkDateFormatter.formatDate(logRecord.getMillis()));
        stringBuffer.append(" ");
        stringBuffer.append(Globals.getRunId());
        stringBuffer.append(" ");
        return stringBuffer;
    }
}

