/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.websphere.application;

import com.ibm.rational.rafw.wsadmin.util.WsadminPropertiesUtil;
import com.ibm.rational.rafw.wsadmin.websphere.application.AbstractApplicationOption;
import com.ibm.rational.rafw.wsadmin.websphere.application.AppBundle;
import com.ibm.rational.rafw.wsadmin.websphere.application.OptionValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationDeploymentProperties {
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationDeploymentProperties == null ? (class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationDeploymentProperties = ApplicationDeploymentProperties.class$("com.ibm.rational.rafw.wsadmin.websphere.application.ApplicationDeploymentProperties")) : class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationDeploymentProperties).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    private String appName;
    private String warClassLoaderPolicy;
    private String classLoaderMode;
    private String versionLong;
    private String versionMajorMinor;
    private List options = new ArrayList();
    private AppBundle rb = AppBundle.getInstance();
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationDeploymentProperties;

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setWarClassLoaderPolicy(String string) {
        this.warClassLoaderPolicy = string;
    }

    public void setClassLoaderMode(String string) {
        this.classLoaderMode = string;
    }

    public void setVersion(String string) {
        this.versionLong = string;
        String[] stringArray = string.split("\\.", 3);
        this.versionMajorMinor = stringArray[0] + stringArray[1];
        logger.log(Level.FINE, "Setting version to: " + this.versionLong + " with short string: " + this.versionMajorMinor);
    }

    public void addOptions(AbstractApplicationOption[] abstractApplicationOptionArray) {
        this.options.addAll(Arrays.asList(abstractApplicationOptionArray));
    }

    public void processFile(String string) throws IOException {
        boolean bl;
        String string2 = "processFile";
        logger.entering(CLASS_NAME, string2, new Object[]{string});
        WsadminPropertiesUtil wsadminPropertiesUtil = new WsadminPropertiesUtil();
        File file = new File(string + "/properties/" + this.appName + ".properties");
        if (file.exists()) {
            bl = false;
            wsadminPropertiesUtil.load(file);
        } else {
            bl = true;
            wsadminPropertiesUtil.setFile(file);
            wsadminPropertiesUtil.addComment(this.rb.getMessage("commentline"));
            wsadminPropertiesUtil.addComment(this.rb.getMessage("header.appName", new Object[]{this.appName}));
            wsadminPropertiesUtil.addComment(this.rb.getMessage("commentline"));
        }
        if (!wsadminPropertiesUtil.containsKey("WAS_VERSION")) {
            wsadminPropertiesUtil.addBlankLine();
            wsadminPropertiesUtil.addComments(this.rb.getAllMessages("WAS_VERSION.parameter"));
        }
        wsadminPropertiesUtil.setProperty("WAS_VERSION", this.versionLong);
        if (!wsadminPropertiesUtil.containsKey("WAR_CLASS_LOADER_POLICY")) {
            wsadminPropertiesUtil.addBlankLine();
            wsadminPropertiesUtil.addComments(this.rb.getAllMessages("WAR_CLASS_LOADER_POLICY.parameter"));
        }
        wsadminPropertiesUtil.setProperty("WAR_CLASS_LOADER_POLICY", this.warClassLoaderPolicy);
        if (!wsadminPropertiesUtil.containsKey("CLASS_LOADER_MODE")) {
            wsadminPropertiesUtil.addBlankLine();
            wsadminPropertiesUtil.addComments(this.rb.getAllMessages("CLASS_LOADER_MODE.parameter"));
        }
        wsadminPropertiesUtil.setProperty("CLASS_LOADER_MODE", this.classLoaderMode);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            AbstractApplicationOption abstractApplicationOption = (AbstractApplicationOption)iterator.next();
            TreeMap treeMap = abstractApplicationOption.getProperties(this.versionMajorMinor);
            Set set = treeMap.keySet();
            if (set.isEmpty()) continue;
            hashSet.add(abstractApplicationOption.getName());
            String string3 = (String)set.iterator().next();
            if (!wsadminPropertiesUtil.containsKey(string3)) {
                wsadminPropertiesUtil.addBlankLine();
                wsadminPropertiesUtil.addComments(this.rb.getAllMessages(abstractApplicationOption.getName() + ".option"));
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                OptionValue optionValue = (OptionValue)treeMap.get(string4);
                if (optionValue.isDefaultValue()) {
                    wsadminPropertiesUtil.addComment(string4 + " = " + optionValue.getValue());
                    wsadminPropertiesUtil.remove(string4);
                    continue;
                }
                wsadminPropertiesUtil.setProperty(string4, optionValue.getValue());
            }
        }
        if (bl) {
            this.addDefaultOptions(wsadminPropertiesUtil, hashSet);
        }
        wsadminPropertiesUtil.store();
        logger.exiting(CLASS_NAME, string2);
    }

    private void addDefaultOptions(WsadminPropertiesUtil wsadminPropertiesUtil, Set set) {
        Object object;
        String string = "addDefaultOptions";
        logger.entering(CLASS_NAME, string, new Object[]{wsadminPropertiesUtil, set});
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration enumeration = this.rb.getKeys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).endsWith(".option")) continue;
            treeSet.add(((String)object).substring(0, ((String)object).indexOf(".option")));
        }
        treeSet.removeAll(set);
        if (treeSet.size() > 0) {
            wsadminPropertiesUtil.addBlankLine();
            wsadminPropertiesUtil.addComment(this.rb.getMessage("commentline"));
            wsadminPropertiesUtil.addComments(this.rb.getAllMessages("header.not.available"));
            wsadminPropertiesUtil.addComment(this.rb.getMessage("commentline"));
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            wsadminPropertiesUtil.addBlankLine();
            wsadminPropertiesUtil.addComments(this.rb.getAllMessages(string2 + ".option"));
            wsadminPropertiesUtil.addComments(this.rb.getAllMessages(string2 + ".default"));
        }
        logger.exiting(CLASS_NAME, string);
    }

    public String getJythonString() {
        String string = "";
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            AbstractApplicationOption abstractApplicationOption = (AbstractApplicationOption)iterator.next();
            string = string + " " + abstractApplicationOption.getJythonString(this.versionMajorMinor);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

