/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def nodename = props['nodeName'];
def name = props['name'];
def webPort = props['webPort'];
def webInstallRoot = props['webInstallRoot'];
def pluginInstallRoot = props['pluginInstallRoot'];
def configurationFile = props['configurationFile'];
def serviceName = props['serviceName'];
def errorLogFile = props['errorLogFile'];
def accessLogFile = props['accessLogFile'];
def webProtocol = props['webProtocol'];
def webAppMapping = props['webAppMapping'];
def adminPort = props['adminPort'];
def adminProtocol = props['adminProtocol'];
def adminUserID = props['adminUserID'];
def adminPasswd = props['adminPasswd'];

StringBuilder nodeNameBuilder = new StringBuilder();
StringBuilder builder = new StringBuilder();
builder.append("createIHSWebServer(")
           .append("\"").append(nodename).append("\"").append(",")
           .append("\"").append(name).append("\"").append(",")
           .append("\"").append(webPort).append("\"").append(",")
           .append("\"").append(webInstallRoot).append("\"").append(",")
           .append("\"").append(pluginInstallRoot).append("\"").append(",")
           .append("\"").append(configurationFile).append("\"").append(",")
           .append("\"").append(serviceName).append("\"").append(",")
           .append("\"").append(errorLogFile).append("\"").append(",")
           .append("\"").append(accessLogFile).append("\"").append(",")
           .append("\"").append(webProtocol).append("\"").append(",")
           .append("\"").append(webAppMapping).append("\"").append(",")
           .append("\"").append(adminPort).append("\"").append(",")
           .append("\"").append(adminProtocol).append("\"").append(",")
           .append("\"").append(adminUserID).append("\"").append(",")
           .append("\"").append(adminPasswd).append("\"")
builder.append(")")
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
