/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def nodenames = props['nodenames'];

StringBuilder nodeNameBuilder = new StringBuilder();
StringBuilder builder = new StringBuilder();
builder.append("enableAutoSync(");
if (nodenames != null && nodenames.trim() != "" && nodenames.trim() != "*") {
    boolean first = true;
    nodeNameBuilder.append("[");
    nodenames.eachLine { line ->
        if (first) {
            first = false;
        }
        else {
            nodeNameBuilder.append(", ");
        }
        nodeNameBuilder.append("\"").append(line.trim()).append("\"");
    }
    nodeNameBuilder.append("]");
    builder.append(nodeNameBuilder.toString());
}
builder.append(")");
command = builder.toString();

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
