/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.WebSphereBatchScriptHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def server = props['server'].trim();
def node = props['node'].trim();
def cluster = props['cluster'].trim();

def appName = props['appName'].trim();
def appEdition = props['appEdition'].trim();

String command;
StringBuilder builder = new StringBuilder();
if (cluster != null && cluster.trim() != "" && !cluster.startsWith('${p:')) {
    builder.append("uninstallApplicationFromCluster(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\'").append(cluster).append("\'")
           .append(")")
    command = builder.toString();
}
else if (server != null && server.trim() != "" && !server.startsWith('${p:')) {
    builder.append("uninstallApplicationFromServer(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"").append(",")
               .append("\'").append(server).append("\'").append(",")
               .append("\'").append(node).append("\'")
           .append(")")
    command = builder.toString();
} 
else { /* Cell scope, remove application from all scopes */
   builder.append("uninstallApplicationFromCell(")
               .append("\"").append(appName).append("\"").append(",")
               .append("\"").append(appEdition?:"").append("\"")
           .append(")")
    command = builder.toString();
}

WebSphereBatchScriptHelper helper = new WebSphereBatchScriptHelper(props);
helper.execute(command);
