/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rafw.wsadmin.websphere.application;

import com.ibm.rational.rafw.wsadmin.websphere.application.AbstractApplicationOption;
import com.ibm.rational.rafw.wsadmin.websphere.application.AppBundle;
import com.ibm.rational.rafw.wsadmin.websphere.application.MultiAppDeploymentOption;
import com.ibm.rational.rafw.wsadmin.websphere.application.SimpleAppDeploymentOption;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationOptionFactory {
    private static final String CLASS_NAME = (class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationOptionFactory == null ? (class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationOptionFactory = ApplicationOptionFactory.class$("com.ibm.rational.rafw.wsadmin.websphere.application.ApplicationOptionFactory")) : class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationOptionFactory).getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.rational.rafw.wsadmin.messages.CRWWA_messages");
    private static final String APP_DEPLOYMENT_OPTIONS_TASK_NAME = "AppDeploymentOptions";
    private static ArrayList APP_DEPLOYMENT_OPTIONS_IGNORE_LIST = new ArrayList();
    private static final String VAL_APP_DEPLOYMENT_OPTION_NO = "AppDeploymentOption.No";
    private static final String VAL_APP_DEPLOYMENT_OPTION_YES = "AppDeploymentOption.Yes";
    private static final String VAL_NULL = "null";
    static /* synthetic */ Class class$com$ibm$rational$rafw$wsadmin$websphere$application$ApplicationOptionFactory;

    public static AbstractApplicationOption[] getOptions(String string, Object[][] objectArray) {
        AppBundle appBundle = AppBundle.getInstance();
        if (APP_DEPLOYMENT_OPTIONS_TASK_NAME.equals(string)) {
            return ApplicationOptionFactory.getSimpleOptions(objectArray);
        }
        if (appBundle.containsKey(string + ".pattern")) {
            AbstractApplicationOption[] abstractApplicationOptionArray = new AbstractApplicationOption[]{new MultiAppDeploymentOption(string, objectArray)};
            return abstractApplicationOptionArray;
        }
        if (!APP_DEPLOYMENT_OPTIONS_IGNORE_LIST.contains(string)) {
            logger.log(Level.WARNING, "CRWWA1001W", new Object[]{string});
        }
        return new AbstractApplicationOption[0];
    }

    private static AbstractApplicationOption[] getSimpleOptions(Object[][] objectArray) {
        ArrayList<SimpleAppDeploymentOption> arrayList = new ArrayList<SimpleAppDeploymentOption>();
        int n = objectArray.length;
        if (n < 2) {
            logger.log(Level.WARNING, "CRWWA1002W", new Object[]{APP_DEPLOYMENT_OPTIONS_TASK_NAME});
            return new AbstractApplicationOption[0];
        }
        int n2 = objectArray[0].length;
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray[0][i];
            if (APP_DEPLOYMENT_OPTIONS_IGNORE_LIST.contains(object)) continue;
            Object object2 = objectArray[1][i];
            if (object2 != null) {
                String string = ApplicationOptionFactory.scrubValue(object2.toString());
                if ((string = ApplicationOptionFactory.scrubBoolean(string)).length() <= 0) continue;
                arrayList.add(new SimpleAppDeploymentOption(object.toString(), string));
                continue;
            }
            logger.log(Level.FINE, "Value is null for key '" + object + "' while reading values for task: " + APP_DEPLOYMENT_OPTIONS_TASK_NAME);
        }
        return arrayList.toArray(new AbstractApplicationOption[arrayList.size()]);
    }

    public static String scrubBoolean(String string) {
        if (VAL_APP_DEPLOYMENT_OPTION_NO.equals(string)) {
            return "false";
        }
        if (VAL_APP_DEPLOYMENT_OPTION_YES.equals(string)) {
            return "true";
        }
        return string;
    }

    public static String scrubValue(String string) {
        if (VAL_NULL.equals(string)) {
            return "";
        }
        return string;
    }

    public static String filterRegexValue(String string) {
        if (VAL_NULL.equals(string)) {
            return ".*";
        }
        string = string.replace('(', '.');
        string = string.replace(')', '.');
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        APP_DEPLOYMENT_OPTIONS_IGNORE_LIST.add("asyncRequestDispatchType");
        APP_DEPLOYMENT_OPTIONS_IGNORE_LIST.add("buildVersion");
        APP_DEPLOYMENT_OPTIONS_IGNORE_LIST.add("validateinstall");
        APP_DEPLOYMENT_OPTIONS_IGNORE_LIST.add("ModuleBuildID");
    }
}

