/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.Duration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class ThreadDump {
    private static String SMALL_TAB = "   ";
    private static String LARGE_TAB = "\t";
    ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
    ThreadInfo[] threadInfos = JAVA_6_INIT.getThreadInfo(this.threadMBean);
    long[] deadlockThreads = JAVA_6_INIT.findDeadlockedThreads(this.threadMBean);

    public boolean isCpuTimeEnabled() {
        return this.threadMBean.isThreadCpuTimeSupported() && this.threadMBean.isThreadCpuTimeEnabled();
    }

    public boolean isMonitorUsageSupported() {
        return JAVA_6_INIT.isObjectMonitorUsageSupported(this.threadMBean);
    }

    public boolean isSynchronizerUsageSupported() {
        return JAVA_6_INIT.isSynchronizerUsageSupported(this.threadMBean);
    }

    public ThreadInfo[] getThreadInfo() {
        return this.threadInfos;
    }

    public String getThreadTitle(ThreadInfo info) {
        this.assertThreadInfoMember(info);
        long threadId = info.getThreadId();
        String threadName = info.getThreadName();
        return String.format("\"%s\" #%d", threadName, threadId);
    }

    public String getThreadState(ThreadInfo info) {
        this.assertThreadInfoMember(info);
        long threadId = info.getThreadId();
        String threadState = String.valueOf((Object)info.getThreadState());
        boolean deadlocked = this.deadlockThreads != null && Arrays.binarySearch(this.deadlockThreads, threadId) != -1;
        StringBuilder sb = new StringBuilder();
        sb.append(threadState);
        String blocker = JAVA_6_INIT.getBlockerString(info);
        if (blocker != null) {
            sb.append(" on lock " + blocker);
            if (info.getLockOwnerName() != null) {
                sb.append(" owned by " + info.getLockOwnerName() + " Id=" + info.getLockOwnerId());
            }
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (native)");
        }
        if (deadlocked) {
            sb.append(" DEADLOCKED");
        }
        return sb.toString();
    }

    public Duration getThreadCpuDuration(ThreadInfo threadInfo) {
        this.assertThreadInfoMember(threadInfo);
        long threadId = threadInfo.getThreadId();
        long threadCpuNano = this.threadMBean.getThreadCpuTime(threadId);
        long threadCpuMilli = threadCpuNano / 1000000L;
        return new Duration(threadCpuMilli);
    }

    public String[] getStackInfo(ThreadInfo threadInfo) {
        this.assertThreadInfoMember(threadInfo);
        ArrayList<String> stackInfos = new ArrayList<String>();
        List<StackTraceElement> stack = Arrays.asList(threadInfo.getStackTrace());
        Object[] monitors = JAVA_6_INIT.getLockedMonitors(threadInfo);
        int monIndex = 0;
        ListIterator<StackTraceElement> stackItr = stack.listIterator();
        while (stackItr.hasNext()) {
            int depth = stackItr.nextIndex();
            StackTraceElement elem = stackItr.next();
            StringBuilder stackInfo = new StringBuilder();
            stackInfo.append("at ");
            stackInfo.append(elem);
            while (monIndex < monitors.length && JAVA_6_INIT.getLockedStackDepth(monitors[monIndex]) == depth) {
                Object monitor = monitors[monIndex];
                int monId = JAVA_6_INIT.getIdentityHashCode(monitor);
                String monClazz = JAVA_6_INIT.getClassName(monitor);
                stackInfo.append("\n" + LARGE_TAB + String.format("- locked <0x%016X> (a %s)", monId, monClazz));
                ++monIndex;
            }
            stackInfos.add(stackInfo.toString());
        }
        return stackInfos.toArray(new String[0]);
    }

    public String[] getLockedSynchronizers(ThreadInfo info) {
        this.assertThreadInfoMember(info);
        Object[] locks = JAVA_6_INIT.getLockedSynchronizers(info);
        ArrayList<String> lockStrings = new ArrayList<String>();
        for (Object lock : locks) {
            lockStrings.add(String.valueOf(lock));
        }
        return lockStrings.toArray(new String[0]);
    }

    private void assertThreadInfoMember(ThreadInfo info) {
        if (Arrays.binarySearch(this.threadInfos, info, new ThreadInfoComparator()) < 0) {
            throw new IllegalArgumentException("Thread does not belong");
        }
    }

    public void write(Writer writer) {
        PrintWriter pw = new PrintWriter(writer);
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String javaVmName = runtimeBean.getVmName();
        String javaVmVer = runtimeBean.getVmVersion();
        String javaVmInfo = System.getProperty("java.vm.info").replaceAll("\r\n|\r|\n", "$0# ");
        pw.println(new Date());
        pw.printf("Full thread dump %s (%s %s):%n", javaVmName, javaVmVer, javaVmInfo);
        pw.println();
        pw.printf("# java version \"%s\"%n", System.getProperty("java.version"));
        pw.printf("# %s (build %s)%n", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"));
        pw.printf("# %s (build %s, %s)%n", javaVmName, javaVmVer, javaVmInfo);
        pw.println();
        pw.printf("# JVM Vendor: %s%n", runtimeBean.getVmVendor());
        pw.printf("# Thread CPU Time Enabled: %s%n", this.isCpuTimeEnabled());
        pw.printf("# Thread Object Monitor Usage Supported: %s%n", this.isMonitorUsageSupported());
        pw.printf("# Thread Synchronizer Usage Supported: %s%n", this.isSynchronizerUsageSupported());
        pw.println();
        for (ThreadInfo threadInfo : this.threadInfos) {
            this.write(threadInfo, this.deadlockThreads, pw);
        }
    }

    private void write(ThreadInfo info, long[] deadlockThreads, PrintWriter pw) {
        pw.println();
        pw.println(this.getThreadTitle(info));
        pw.printf(SMALL_TAB + "java.lang.Thread.State: %s%n", this.getThreadState(info));
        for (String stack : this.getStackInfo(info)) {
            pw.println(LARGE_TAB + stack);
        }
        String[] threadSyncs = this.getLockedSynchronizers(info);
        pw.println(SMALL_TAB + "Locked synchronizers: count = " + threadSyncs.length);
        for (String sync : threadSyncs) {
            pw.println(LARGE_TAB + "locked - " + sync);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.write(writer);
        return writer.toString();
    }

    private static class LockStackDepthComparator
    implements Comparator<Object> {
        private LockStackDepthComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return JAVA_6_INIT.getLockedStackDepth(o1) - JAVA_6_INIT.getLockedStackDepth(o2);
        }
    }

    private static class ThreadInfoComparator
    implements Comparator<ThreadInfo> {
        private ThreadInfoComparator() {
        }

        @Override
        public int compare(ThreadInfo o1, ThreadInfo o2) {
            CompareToBuilder comp = new CompareToBuilder();
            comp.append(o1.getThreadName(), o2.getThreadName(), String.CASE_INSENSITIVE_ORDER);
            comp.append(o1.getThreadId(), o2.getThreadId());
            return comp.toComparison();
        }
    }

    private static class JAVA_6_INIT {
        static Class<?> MonitorInfo = null;
        static Method getThreadInfo = null;
        static Method findDeadlockedThreads = null;
        static Method getLockInfo = null;
        static Method getLockedMonitors = null;
        static Method getLockedStackDepth = null;
        static Method getLockedSynchronizers = null;
        static Method isObjectMonitorUsageSupported = null;
        static Method isSynchronizerUsageSupported = null;
        static Method getIdentityHashCode = null;
        static Method getClassName = null;

        private JAVA_6_INIT() {
        }

        static ThreadInfo[] getThreadInfo(ThreadMXBean threadMBean) {
            long[] threadIds = threadMBean.getAllThreadIds();
            ThreadInfo[] result = (ThreadInfo[])JAVA_6_INIT.invoke(getThreadInfo, threadMBean, threadIds, true, true);
            if (result == null) {
                result = threadMBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            }
            Arrays.sort(result, new ThreadInfoComparator());
            return result;
        }

        static long[] findDeadlockedThreads(ThreadMXBean threadMBean) {
            long[] result = findDeadlockedThreads != null ? (long[])JAVA_6_INIT.invoke(findDeadlockedThreads, threadMBean, new Object[0]) : threadMBean.findMonitorDeadlockedThreads();
            if (result != null) {
                Arrays.sort(result);
            }
            return result;
        }

        static Object[] getLockedMonitors(ThreadInfo info) {
            Object[] result = (Object[])JAVA_6_INIT.invoke(getLockedMonitors, info, new Object[0]);
            if (result != null) {
                Arrays.sort(result, new LockStackDepthComparator());
                return result;
            }
            return new Object[0];
        }

        static int getLockedStackDepth(Object monitorInfo) {
            Integer result = (Integer)JAVA_6_INIT.invoke(getLockedStackDepth, monitorInfo, new Object[0]);
            return result == null ? 0 : result;
        }

        static Object[] getLockedSynchronizers(ThreadInfo info) {
            if (getLockedSynchronizers != null) {
                return (Object[])JAVA_6_INIT.invoke(getLockedSynchronizers, info, new Object[0]);
            }
            return new Object[0];
        }

        static boolean isMonitorInfo(Object lockInfo) {
            return MonitorInfo == null || MonitorInfo.isInstance(lockInfo);
        }

        static boolean isObjectMonitorUsageSupported(ThreadMXBean bean) {
            Boolean result = (Boolean)JAVA_6_INIT.invoke(isObjectMonitorUsageSupported, bean, new Object[0]);
            return Boolean.TRUE.equals(result);
        }

        static boolean isSynchronizerUsageSupported(ThreadMXBean bean) {
            Boolean result = (Boolean)JAVA_6_INIT.invoke(isSynchronizerUsageSupported, bean, new Object[0]);
            return Boolean.TRUE.equals(result);
        }

        static int getIdentityHashCode(Object lockInfo) {
            Integer result = (Integer)JAVA_6_INIT.invoke(getIdentityHashCode, lockInfo, new Object[0]);
            return result == null ? 0 : result;
        }

        static String getClassName(Object lockInfo) {
            return (String)JAVA_6_INIT.invoke(getClassName, lockInfo, new Object[0]);
        }

        static String getBlockerString(ThreadInfo threadInfo) {
            Object lockInfo = JAVA_6_INIT.invoke(getLockInfo, threadInfo, new Object[0]);
            if (lockInfo != null) {
                return String.format("<0x%016X> (a %s)", JAVA_6_INIT.getIdentityHashCode(lockInfo), JAVA_6_INIT.getClassName(lockInfo));
            }
            return threadInfo.getLockOwnerName();
        }

        private static Object invoke(Method m, Object o, Object ... args) {
            if (m != null) {
                try {
                    return m.invoke(o, args);
                }
                catch (IllegalAccessException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            try {
                getThreadInfo = ThreadMXBean.class.getMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
                findDeadlockedThreads = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
                getLockInfo = ThreadInfo.class.getMethod("getLockInfo", new Class[0]);
                getLockedMonitors = ThreadInfo.class.getMethod("getLockedMonitors", new Class[0]);
                MonitorInfo = Class.forName("java.lang.management.MonitorInfo");
                getLockedStackDepth = MonitorInfo.getMethod("getLockedStackDepth", new Class[0]);
                getLockedSynchronizers = ThreadInfo.class.getMethod("getLockedSynchronizers", new Class[0]);
                isObjectMonitorUsageSupported = ThreadMXBean.class.getMethod("isObjectMonitorUsageSupported", new Class[0]);
                isSynchronizerUsageSupported = ThreadMXBean.class.getMethod("isSynchronizerUsageSupported", new Class[0]);
                Class<?> LockInfo2 = Class.forName("java.lang.management.LockInfo");
                getIdentityHashCode = LockInfo2.getMethod("getIdentityHashCode", new Class[0]);
                getClassName = LockInfo2.getMethod("getClassName", new Class[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

